package org.lsst.ccs.messaging.jgroups;

import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.TransportManager;


/**
 */
public class JGroupsTransportManager extends TransportManager {

    /**
     * Constructs an instance of {@code MessagingLayer}.
     * 
     * @param protocolString Protocol selection and configuration string in 
     *                       {@code jgroups[:configuration_file_name[:dispatcher_configuration]}
     *                       format.
     * @return Instance of {@code MessagingLayer}, or {@code null} if {@code protocolString} does not start with "jgroups".
     */
    @Override
    protected BusMessagingLayer getInstance(String protocolString) {

        if (protocolString.startsWith("jgroups")) {
            
            if ("jgroups".equals(protocolString)) {
                protocolString = JGroupsBusMessagingLayer.DEFAULT_UDP_PROTOCOL;
            }
            
            JGroupsBusMessagingLayer layer = new JGroupsBusMessagingLayer(protocolString);
            return layer;
        } else {
            return null;
        }
    }

}
