package org.lsst.ccs.messaging.jgroups;

import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import org.jgroups.View;
import org.lsst.ccs.bus.definition.Bus;

/**
 *
 * @author onoprien
 */
public class JGroupsMonitor {

// -- Fields : -----------------------------------------------------------------
    
    private final int MAX_RECORDS = 100;
    private EnumMap<Bus,LinkedList<Record>> records;
    
    private final ExecutorService exec = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "JGroups monitor");
        t.setDaemon(true);
        return t;
    });

// -- Life cycle : -------------------------------------------------------------
    
// -- Logging : ----------------------------------------------------------------
    
    public void addRecord(Bus bus, String message, Exception exception) {
        try {
            exec.execute(() -> doAddRecord(bus, message, exception));
        } catch (RejectedExecutionException x) {
        }
    }
    
    public void addRecord(Bus bus, View oldView, View view) {
        try {
            exec.execute(() -> doAddRecord(bus, oldView, view));
        } catch (RejectedExecutionException x) {
        }
    }
    
    private void doAddRecord(Bus bus, String message, Exception exception) {
        
    }
    
    private void doAddRecord(Bus bus, View oldView, View view) {
        
    }
    
    /**
     * Runs the provided consumer on the list of the last 100 log entries for the specified bus.
     * This method returns immediately, without waiting for the consumer to execute. The execution is 
     * scheduled on the monitor main thread, with then-current list of records.
     * 
     * @param consumer Task to execute.
     * @param bus Bus.
     */
    public void getRecords(Consumer<List<Record>> consumer, Bus bus) {
        
    }
    
    static public class Record {
        
        public final long time;
        public final String message;
        public final Exception exception;
        
        Record(String message, Exception exception) {
            this.time = System.currentTimeMillis();
            this.message = message;
            this.exception = exception;
        }

        @Override
        public String toString() {
            if (exception == null) {
                return message;
            } else {
                return message +"\n"+ exception;
            }
        }
        
    }
    
}
