/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.io.InputStream;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

public class GroupsTest5 {
    public static void main(String[] args) throws Exception {
        InputStream stream = BootstrapResourceUtils.getBootstrapResource((String)"udp.xml", GroupsTest5.class);
        JChannel channelAX = new JChannel(stream);
        channelAX.setName("subsystem X");
        channelAX.connect("busA");
        Address addressAX = channelAX.getAddress();
        JChannel channelAY = new JChannel(stream);
        channelAY.setName("subsystem Y");
        channelAY.connect("busA");
        Address addressAY = channelAX.getAddress();
        System.setProperty("jgroups.udp.mcast_port", "6970");
        JChannel channelBX = new JChannel(stream);
        channelBX.setName("subsystem X");
        channelBX.connect("busB");
        Address addressBX = channelBX.getAddress();
        ReceiverAdapter receiver = new ReceiverAdapter(){

            public void viewAccepted(View new_view) {
                System.out.println("** view: created by " + new_view.getCreator());
            }

            public void receive(Message msg) {
                System.out.println(msg.getSrc() + ": " + msg.getObject());
            }
        };
        channelAX.setReceiver((Receiver)receiver);
        channelAY.setReceiver((Receiver)receiver);
        channelBX.setReceiver((Receiver)receiver);
        channelAX.send(null, (Object)"for ALL A");
        channelBX.send(null, (Object)"for ALL B");
        channelAY.send(addressAX, (Object)"for X  A");
        Thread.sleep(5000L);
        channelAX.close();
        channelAY.close();
        channelBX.close();
    }
}

