/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.maven.pugin.properties;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class JndiPropertiesFileGeneratorMojo
extends AbstractMojo {
    private MavenProject mavenProject;
    private String serverName;
    private String serverPort;
    private String resourcesDirectory;
    private OutputStreamWriter out;
    static final Set<String> supportedServers = new HashSet<String>();
    static final String lineSeparator;

    static {
        supportedServers.add("GlassFish3");
        supportedServers.add("JBoss");
        lineSeparator = System.getProperty("line.separator");
    }

    public void execute() throws MojoExecutionException {
        List<Profile> activeProfiles = JndiPropertiesFileGeneratorMojo.getAllActiveProfiles(this.mavenProject);
        HashSet<String> activeServerProfile = new HashSet<String>();
        for (Profile p : activeProfiles) {
            String id = p.getId();
            if (!supportedServers.contains(id)) continue;
            activeServerProfile.add(id);
        }
        if (activeServerProfile.isEmpty()) {
            throw new MojoExecutionException("No Profiles were active for the supported servers (JBoss,GlassFish3). No Properties file has been generated ");
        }
        if (activeServerProfile.size() != 1) {
            throw new MojoExecutionException("More than one Server profile has been activated: " + activeServerProfile + ". Please make sure to choose only one. No Properties file has been generated ");
        }
        try {
            if (!this.resourcesDirectory.endsWith("/")) {
                this.resourcesDirectory = String.valueOf(this.resourcesDirectory) + "/";
            }
            File targetDirectory = new File(this.resourcesDirectory);
            targetDirectory.mkdirs();
            File outputFile = new File(targetDirectory, "jndi.properties");
            this.out = new OutputStreamWriter(new FileOutputStream(outputFile));
            this.getLog().info((CharSequence)("Generating output file " + outputFile.toString() + " for " + activeServerProfile.iterator().next() + " server (" + this.serverName + ":" + this.serverPort + ")"));
            if (activeServerProfile.contains("JBoss")) {
                this.createJBossJndiProperties();
            } else if (activeServerProfile.contains("GlassFish3")) {
                this.createGlassFishJndiProperties();
            }
            this.out.flush();
        }
        catch (Exception ffe) {
            throw new MojoExecutionException("Problem creating jndi.properties file ", ffe);
        }
    }

    void createJBossJndiProperties() throws IOException {
        this.out.write("java.naming.factory.initial=org.jnp.interfaces.NamingContextFactory" + lineSeparator);
        this.out.write("java.naming.factory.url.pkgs=org.jboss.naming" + lineSeparator);
        this.out.write("jboss.host=" + this.serverName + lineSeparator);
        this.out.write("java.naming.provider.url=jnp://" + this.serverName + ":" + this.serverPort);
    }

    void createGlassFishJndiProperties() throws IOException {
        this.out.write("java.naming.factory.initial=com.sun.enterprise.naming.SerialInitContextFactory" + lineSeparator);
        this.out.write("java.naming.factory.url.pkgs=com.sun.enterprise.naming" + lineSeparator);
        this.out.write("java.naming.factory.state=com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl" + lineSeparator);
        this.out.write("org.omg.CORBA.ORBInitialHost=" + this.serverName + lineSeparator);
        this.out.write("org.omg.CORBA.ORBInitialPort=" + this.serverPort);
    }

    public static List<Profile> getAllActiveProfiles(MavenProject project) {
        ArrayList<Profile> list = new ArrayList<Profile>();
        JndiPropertiesFileGeneratorMojo.getAllActiveProfiles(project, list);
        return list;
    }

    public static void getAllActiveProfiles(MavenProject project, List<Profile> list) {
        List activeProfiles = project.getActiveProfiles();
        int i = 0;
        while (i < activeProfiles.size()) {
            list.add((Profile)activeProfiles.get(i));
            ++i;
        }
        MavenProject parent = project.getParent();
        if (parent != null) {
            JndiPropertiesFileGeneratorMojo.getAllActiveProfiles(parent, list);
        }
    }
}

