/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.messaging.LockLevelService;
import org.lsst.ccs.services.AgentLockServiceDelegate;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.LocalAgentLockService;
import org.lsst.ccs.services.RemoteAgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;

public class AgentLockService
implements LockLevelService,
ServiceLifecycle,
AgentService {
    AgentLockServiceDelegate delegate;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLoginService agentLoginService;

    Agent getAgent() {
        return this.agent;
    }

    public AgentStateService getAgentStateService() {
        return this.agentStateService;
    }

    public AgentLoginService getAgentLoginService() {
        return this.agentLoginService;
    }

    @Override
    public String getAgentServiceName() {
        return "lockService";
    }

    @Override
    public void preInit() {
        String p;
        switch (p = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.lockservice", "local")) {
            case "remote": {
                this.delegate = new RemoteAgentLockService(this);
                break;
            }
            case "local": {
                this.delegate = new LocalAgentLockService(this);
                break;
            }
            default: {
                throw new RuntimeException("Invalid org.lsst.ccs.lockservice value " + p);
            }
        }
        this.delegate.preInit();
    }

    @Override
    public void preStart() {
        this.delegate.preStart();
    }

    public void setLevelForAgent(String agentName, int level) throws UnauthorizedLevelException, UnauthorizedLockException, IOException {
        this.delegate.setLevelForAgent(agentName, level);
    }

    public int getLevelForAgent(String agentName) {
        return this.delegate.getLevelForAgent(agentName);
    }

    public AgentLock getLockForAgent(String agentName) {
        return this.delegate.getLockForAgent(agentName);
    }

    public AgentLock getExistingLockForAgent(String agentName) {
        return this.delegate.getExistingLockForAgent(agentName);
    }

    public void lockAgent(String agentName) throws UnauthorizedLockException, IOException {
        this.delegate.lockAgent(agentName);
    }

    public void unlockAgent(String agentName) throws UnauthorizedLockException, IOException {
        this.delegate.unlockAgent(agentName);
    }

    public void attachLock(String agentName) throws UnauthorizedLockException, IOException {
        this.delegate.attachLock(agentName);
    }

    public void detachLock(String agentName) throws UnauthorizedLockException, IOException {
        this.delegate.detachLock(agentName);
    }

    public Map<String, AgentLock> getLocks() {
        return this.delegate.getLocks();
    }

    public Map<String, AgentLock> getHeldLocks() {
        return this.delegate.getHeldLocks();
    }

    public boolean validateLock(AgentLock lock) {
        return this.delegate.validateLock(lock);
    }

    public String getUserId() {
        return this.agentLoginService.getUserId();
    }

    public void addAgentLockUpdateListener(AgentLockUpdateListener slul) {
        this.delegate.addAgentLockUpdateListener(slul);
    }

    public void removeAgentLockUpdateListener(AgentLockUpdateListener l) {
        this.delegate.removeAgentLockUpdateListener(l);
    }

    public List<String> getLockableAgents() {
        return this.delegate.getLockableAgents();
    }

    public List<String> getAttachableAgents() {
        return this.delegate.getAttachableAgents();
    }

    public List<String> getDetachableAgents() {
        return this.delegate.getDetachableAgents();
    }

    public List<String> getLockedAgents() {
        return this.delegate.getLockedAgents();
    }

    public List<String> getLocallyLockedAgents() {
        return this.delegate.getLocallyLockedAgents();
    }

    public List<String> getAllWorkerAgents() {
        return this.delegate.getAllWorkerAgents();
    }

    public void destroyLock(String agentName, String userId) {
        this.delegate.destroyLock(agentName, userId);
    }

    public static interface AgentLockUpdateListener {
        default public void onAgentHeldLockUpdate(String agentName, AgentLock lock) {
        }

        default public void onAgentLockUpdate(String agentName, String owner, AgentLock lock) {
        }

        default public void onGlobalLockUpdate(String agentName, String owner, AgentLock lock) {
        }

        default public void onAgentLevelChange(String agentName, int level) {
        }
    }
}

