/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;

public class TrendingConnectionUtils {
    private final Client client = ClientBuilder.newClient();
    private final String baseUrl;
    private final WebTarget serv;
    private static final Logger LOG = Logger.getLogger(TrendingConnectionUtils.class.getName());

    public TrendingConnectionUtils(String serverName, int serverPort) {
        this(serverName, serverPort, "/rest/data");
    }

    public TrendingConnectionUtils(String serverName, int serverPort, String entryPoint) {
        this.baseUrl = String.format("http://%s:%d%s", serverName, serverPort, entryPoint);
        this.serv = this.client.target(this.baseUrl).path("dataserver");
    }

    public DataChannel.DataChannelList getChannelList() {
        return (DataChannel.DataChannelList)this.serv.path("listchannels").request(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
    }

    public TrendingData getLatestData(String path) {
        TrendingData res = null;
        try {
            res = (TrendingData)this.serv.path("data/latest").queryParam("path", new Object[]{path}).request(new String[]{"text/xml"}).get(TrendingData.class);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception while fetching latest data for path: " + path, e);
        }
        return res;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

