/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCacheFactory;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheMonitor;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.remote.RemoteLocation;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;

public class RemoteCacheFactory
extends AbstractAuxiliaryCacheFactory {
    private RemoteCacheMonitor monitor;
    private ConcurrentMap<RemoteLocation, RemoteCacheManager> managers;
    private Lock managerLock;

    @Override
    public <K, V> AuxiliaryCache<K, V> createCache(AuxiliaryCacheAttributes iaca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        RemoteCacheAttributes rca = (RemoteCacheAttributes)iaca;
        ArrayList noWaits = new ArrayList();
        switch (rca.getRemoteType()) {
            case LOCAL: {
                String failoverList;
                ArrayList<RemoteLocation> failovers = new ArrayList<RemoteLocation>();
                boolean primaryDefined = false;
                if (rca.getRemoteLocation() != null) {
                    primaryDefined = true;
                    failovers.add(rca.getRemoteLocation());
                    RemoteCacheManager rcm = this.getManager(rca, cacheMgr, cacheEventLogger, elementSerializer);
                    RemoteCacheNoWait ic = rcm.getCache(rca);
                    noWaits.add(ic);
                }
                if ((failoverList = rca.getFailoverServers()) != null) {
                    StringTokenizer fit = new StringTokenizer(failoverList, ",");
                    int fCnt = 0;
                    while (fit.hasMoreTokens()) {
                        ++fCnt;
                        String server = fit.nextToken();
                        RemoteLocation location = RemoteLocation.parseServerAndPort(server);
                        if (location == null) continue;
                        failovers.add(location);
                        rca.setRemoteLocation(location);
                        RemoteCacheManager rcm = this.getManager(rca, cacheMgr, cacheEventLogger, elementSerializer);
                        if ((primaryDefined || fCnt != 1) && noWaits.size() > 0) continue;
                        RemoteCacheNoWait ic = rcm.getCache(rca);
                        noWaits.add(ic);
                    }
                }
                rca.setFailovers(failovers);
                break;
            }
            case CLUSTER: {
                StringTokenizer it = new StringTokenizer(rca.getClusterServers(), ",");
                while (it.hasMoreElements()) {
                    String server = (String)it.nextElement();
                    RemoteLocation location = RemoteLocation.parseServerAndPort(server);
                    if (location == null) continue;
                    rca.setRemoteLocation(location);
                    RemoteCacheManager rcm = this.getManager(rca, cacheMgr, cacheEventLogger, elementSerializer);
                    rca.setRemoteType(RemoteType.CLUSTER);
                    RemoteCacheNoWait ic = rcm.getCache(rca);
                    noWaits.add(ic);
                }
                break;
            }
        }
        RemoteCacheNoWaitFacade rcnwf = new RemoteCacheNoWaitFacade(noWaits, rca, cacheEventLogger, elementSerializer, this);
        return rcnwf;
    }

    public RemoteCacheManager getManager(IRemoteCacheAttributes cattr) {
        if (cattr.getRemoteLocation() == null) {
            cattr.setRemoteLocation("", 1099);
        }
        RemoteLocation loc = cattr.getRemoteLocation();
        RemoteCacheManager ins = (RemoteCacheManager)this.managers.get(loc);
        return ins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteCacheManager getManager(IRemoteCacheAttributes cattr, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        RemoteCacheManager ins = this.getManager(cattr);
        if (ins == null) {
            this.managerLock.lock();
            try {
                ins = (RemoteCacheManager)this.managers.get(cattr.getRemoteLocation());
                if (ins == null) {
                    ins = new RemoteCacheManager(cattr, cacheMgr, this.monitor, cacheEventLogger, elementSerializer);
                    this.managers.put(cattr.getRemoteLocation(), ins);
                    this.monitor.addManager(ins);
                }
            }
            finally {
                this.managerLock.unlock();
            }
        }
        return ins;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.managers = new ConcurrentHashMap<RemoteLocation, RemoteCacheManager>();
        this.managerLock = new ReentrantLock();
        this.monitor = new RemoteCacheMonitor();
        this.monitor.setDaemon(true);
    }

    @Override
    public void dispose() {
        for (RemoteCacheManager manager : this.managers.values()) {
            manager.release();
        }
        this.managers.clear();
        if (this.monitor != null) {
            this.monitor.notifyShutdown();
            try {
                this.monitor.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.monitor = null;
        }
        super.dispose();
    }
}

