/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.trendserver;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentPropertyPredicate;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.utils.TrendingConnectionUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.utilities.logging.Logger;

public class TrendingClientService
implements AgentService,
ServiceLifecycle,
AgentPresenceListener,
HasLifecycle {
    public static final String USES_TRENDING_SERVICE = "usesTrending";
    private static final Map<String, String> props = new HashMap<String, String>();
    private static final AgentPropertyPredicate REST_AGENT_PREDICATE;
    private Logger log = Logger.getLogger((String)TrendingClientService.class.getName());
    private final Map<String, TrendingConnectionUtils> availableClients = new ConcurrentHashMap<String, TrendingConnectionUtils>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent a;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;

    public String getAgentServiceName() {
        return "trendingClientService";
    }

    public boolean startForAgent(AgentInfo agentInfo) {
        boolean usesTrendingService = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.agent.usesTrending", "false").toLowerCase().equals("true");
        return usesTrendingService;
    }

    public void build() {
        this.agentPropertiesService.setAgentProperty(USES_TRENDING_SERVICE, "true");
    }

    public void preStart() {
        this.a.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        try {
            if (!this.a.getMessagingAccess().getAgentPresenceManager().waitForAgent(REST_AGENT_PREDICATE, 3L, TimeUnit.SECONDS)) {
                this.log.warning((Object)"Could not establish a connection with the rest server at startup.");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!REST_AGENT_PREDICATE.test(agent)) continue;
            String host = agent.getAgentProperty("rest-service-addr");
            String port = agent.getAgentProperty("rest-service-port");
            String entryPoint = agent.getAgentProperty("rest-service-entrypoint");
            BusTredningConnectionUtils restClient = new BusTredningConnectionUtils(host, Integer.valueOf(port), entryPoint);
            Map<String, TrendingConnectionUtils> map = this.availableClients;
            synchronized (map) {
                if (this.availableClients.containsKey(agent.getName())) {
                    throw new RuntimeException("There is already a valid connection to rest server " + agent.getName());
                }
                this.availableClients.put(agent.getName(), restClient);
            }
            this.log.debug((Object)("Established a connection with the rest server " + restClient.getBaseUrl()));
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!REST_AGENT_PREDICATE.test(agent)) continue;
            this.availableClients.remove(agent.getName());
            this.log.debug((Object)"Lost connection with the rest-server.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrendingConnectionUtils createClientRequestUtils(String name, String host, int port) {
        TrendingConnectionUtils result = new TrendingConnectionUtils(host, port);
        Map<String, TrendingConnectionUtils> map = this.availableClients;
        synchronized (map) {
            if (this.availableClients.containsKey(name)) {
                throw new RuntimeException("There is already a name connection: " + name);
            }
            this.availableClients.put(name, result);
        }
        this.log.debug((Object)("Created custom connection with the rest server " + result.getBaseUrl()));
        return result;
    }

    public Set<String> getNamedTrendingConnections() {
        return this.availableClients.keySet();
    }

    public TrendingConnectionUtils getTrendingConnection(String name) {
        return this.availableClients.get(name);
    }

    public TrendingConnectionUtils getBusTrendingConnection() {
        for (TrendingConnectionUtils connection : this.availableClients.values()) {
            if (!(connection instanceof BusTredningConnectionUtils)) continue;
            return connection;
        }
        return null;
    }

    static {
        props.put("agentCategory", AgentCategory.REST_SERVER.name());
        REST_AGENT_PREDICATE = new AgentPropertyPredicate(props);
    }

    private class BusTredningConnectionUtils
    extends TrendingConnectionUtils {
        BusTredningConnectionUtils(String host, int port, String entryPoint) {
            super(host, port, entryPoint);
        }
    }
}

