/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class CCSBusesConfigurationDAO
implements ConfigurationDAO {
    private final AgentPresenceManager apm;
    private final ConcurrentMessagingUtils cmu;
    private static final String DB_NAME = "localdb/configuration-server";
    Logger log = Logger.getLogger((String)"org.lsst.ccs.config");

    public CCSBusesConfigurationDAO(AgentMessagingLayer aml) {
        this.cmu = new ConcurrentMessagingUtils(aml);
        this.apm = aml.getAgentPresenceManager();
        this.log.debug((Object)"instanciated CCSBusesConfigurationDAO");
    }

    private void waitForService() {
        try {
            this.apm.waitForAgent(DB_NAME, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ConfigurationDescription saveChangesForCategoriesAs(String agentName, ConfigurationDescription configDesc, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        return this.registerConfiguration(agentName, configInfo);
    }

    @Override
    public ConfigurationView loadConfiguration(String agentName, ConfigurationDescription configDesc) throws ConfigurationServiceException {
        try {
            this.log.debug((Object)("loadConfiguration " + agentName + " " + configDesc));
            this.log.debug((Object)("remote loadconfig desc tags " + configDesc.getCategoryTags().entrySet()));
            this.waitForService();
            this.log.debug((Object)("sending command " + agentName + " " + configDesc));
            return (ConfigurationView)this.cmu.sendSynchronousCommand(new CommandRequest(DB_NAME, "loadConfiguration", new Object[]{agentName, configDesc}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ConfigurationServiceException("remote configuration error", ex);
        }
    }

    @Override
    public ConfigurationView loadGlobalConfiguration(String agentName, String name, int version) {
        try {
            this.log.debug((Object)("loadGlobalConfiguration " + agentName + " " + name + " " + version));
            return (ConfigurationView)this.cmu.sendSynchronousCommand(new CommandRequest(DB_NAME, "loadGlobalConfiguration", new Object[]{agentName, name, version}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ConfigurationServiceException("remote configuration error", ex);
        }
    }

    @Override
    public Set<String> findAvailableConfigurationsForCategory(String agentName, String category) {
        return null;
    }

    @Override
    public boolean isAvailable() {
        return this.apm.agentExists("localdb");
    }

    @Override
    public ConfigurationDescription registerConfiguration(String agentName, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        try {
            this.log.debug((Object)("registerConfiguration " + agentName + " " + configInfo));
            return (ConfigurationDescription)this.cmu.sendSynchronousCommand(new CommandRequest(DB_NAME, "registerConfiguration", new Object[]{agentName, configInfo}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ConfigurationServiceException("remote configuration error", ex);
        }
    }
}

