/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.ScriptingCommandResponse;
import org.lsst.ccs.scripting.ScriptingTimeoutException;

public class ScriptingSubsystemWrapper {
    private final ConcurrentMessagingUtils cmdAgent;
    private final String subsystemName;

    protected ScriptingSubsystemWrapper(String subsystemName, ConcurrentMessagingUtils cmdAgent) {
        this.cmdAgent = cmdAgent;
        this.subsystemName = subsystemName;
    }

    ConcurrentMessagingUtils getConcurrentMessagingUtils() {
        return this.cmdAgent;
    }

    @Deprecated
    public ScriptingCommandResponse synchCommand(int timeout, String commandName, Object ... args) throws ScriptingTimeoutException, Exception {
        return (ScriptingCommandResponse)this.internalSynchCommand(Duration.ofSeconds(timeout), ScriptingSubsystemWrapper.parseCommand(this, commandName, args), false);
    }

    public Object sendSynchCommand(String commandName, Object ... args) throws ScriptingTimeoutException, Exception {
        return this.internalSynchCommand(null, ScriptingSubsystemWrapper.parseCommand(this, commandName, args), true);
    }

    @Deprecated
    public Object sendSynchCommand(int timeout, String commandName, Object ... args) throws ScriptingTimeoutException, Exception {
        return this.internalSynchCommand(Duration.ofSeconds(timeout), ScriptingSubsystemWrapper.parseCommand(this, commandName, args), true);
    }

    public Object sendSynchCommand(Duration timeout, String commandName, Object ... args) throws ScriptingTimeoutException, Exception {
        return this.internalSynchCommand(timeout, ScriptingSubsystemWrapper.parseCommand(this, commandName, args), true);
    }

    private Object internalSynchCommand(Duration timeout, CommandRequest cmd, boolean returnResult) throws ScriptingTimeoutException, Exception {
        Object result = null;
        try {
            result = timeout == null ? this.cmdAgent.sendSynchronousCommand(cmd) : this.cmdAgent.sendSynchronousCommand(cmd, timeout);
        }
        catch (TimeoutException ex) {
            ScriptingTimeoutException timeoutException = new ScriptingTimeoutException("timeout", ex);
            if (CCS.getThrowExceptions()) {
                throw timeoutException;
            }
            result = timeoutException;
        }
        catch (Exception e) {
            if (CCS.getThrowExceptions()) {
                throw e;
            }
            result = e;
        }
        if (returnResult) {
            return result;
        }
        return new ScriptingCommandResponse(result);
    }

    @Deprecated
    public ScriptingCommandResponse synchCommandLine(int timeout, String command) throws ScriptingTimeoutException, Exception {
        return (ScriptingCommandResponse)this.internalSynchCommand(Duration.ofSeconds(timeout), ScriptingSubsystemWrapper.parseCommand(this, command, new Object[0]), false);
    }

    @Deprecated
    public Future<Object> asynchCommand(String commandName, Object ... args) throws Exception {
        return this.internalAsynchCommand(ScriptingSubsystemWrapper.parseCommand(this, commandName, args));
    }

    public Future<Object> sendAsynchCommand(String commandName, Object ... args) throws Exception {
        return this.internalAsynchCommand(ScriptingSubsystemWrapper.parseCommand(this, commandName, args));
    }

    public Future<Object> internalAsynchCommand(CommandRequest cmd) throws Exception {
        Future f = null;
        try {
            f = this.cmdAgent.sendAsynchronousCommand(cmd);
        }
        catch (Exception e) {
            final Exception ex = e;
            if (CCS.getThrowExceptions()) {
                throw ex;
            }
            f = new Future(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                public Object get() throws InterruptedException, ExecutionException {
                    return ex;
                }

                public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return ex;
                }
            };
        }
        return f;
    }

    @Deprecated
    public Future<Object> asynchCommandLine(String command) throws Exception {
        return this.internalAsynchCommand(ScriptingSubsystemWrapper.parseCommand(this, command, new Object[0]));
    }

    private static synchronized CommandRequest parseCommand(ScriptingSubsystemWrapper wrapper, String commandLine, Object ... args) {
        String[] commandTokens = commandLine.trim().split(" ");
        String commandStr = commandLine;
        String commandTarget = wrapper.subsystemName;
        int numberOfTokens = commandTokens.length;
        if (numberOfTokens > 1) {
            String possibleModule = commandTokens[0];
            List<String> targets = CCS.getTargetsForSubsystem(wrapper.subsystemName);
            if (targets != null) {
                for (String target : targets) {
                    if (!target.endsWith(possibleModule)) continue;
                    commandStr = commandStr.replace(possibleModule + " ", "");
                    commandTarget = commandTarget + "/" + possibleModule;
                    --numberOfTokens;
                    break;
                }
            }
        }
        if (args == null || args.length == 0) {
            return new CommandRequest(commandTarget, commandStr);
        }
        if (numberOfTokens > 1) {
            throw new IllegalArgumentException("Object arguments cannot be specified along side string arguments: " + commandLine + " (" + args + ")");
        }
        return new CommandRequest(commandTarget, commandStr, args);
    }
}

