/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.services.alert.AlertService;

public abstract class AlertRaisingAlarm
extends Alarm
implements ClearAlertHandler {
    private static final Logger LOG = Logger.getLogger(AlertRaisingAlarm.class.getName());
    private final List<String> raisedAlertIdList = new CopyOnWriteArrayList<String>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;

    @Override
    public void build() {
        if (this.alertService == null) {
            throw new RuntimeException("AlertRaisingAlarm instances must be part of the agent object tree. The AlertService instance must be non null.");
        }
        super.build();
    }

    public abstract Alert getAlert();

    @Override
    void processAlarmTrigger(String alarmCause) {
        Alert alert = this.getAlert();
        if (alert != null) {
            AlertState alertState = AlertRaisingAlarm.getAlertState(this.getAlarmState());
            LOG.log(AlertRaisingAlarm.getLogLevel(this.getAlarmState()), "Processing Alarm {0} at level {1}.\nRaising Alert {2} with AlertState {3} caused by {4}.", new Object[]{this.description, this.getAlarmState(), alert.getAlertId(), alertState, alarmCause});
            this.alertService.raiseAlert(alert, alertState, alarmCause);
            if (!this.raisedAlertIdList.contains(alert.getAlertId())) {
                this.raisedAlertIdList.add(alert.getAlertId());
            }
        } else {
            LOG.log(Level.WARNING, "Null Alert provided, so no Alert is raised.");
        }
    }

    @Override
    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
        if (this.raisedAlertIdList.contains(alert.getAlertId())) {
            LOG.log(Level.INFO, "Clearing alert {0} at state {1}", new Object[]{alert, state});
            if (state.compareTo((Enum)AlertState.WARNING) <= 0) {
                this.clearState();
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
            return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    private static AlertState getAlertState(DataProviderState state) {
        switch (state) {
            case ALARM: {
                return AlertState.ALARM;
            }
            case WARNING: {
                return AlertState.WARNING;
            }
            case NOMINAL: {
                return AlertState.NOMINAL;
            }
        }
        throw new IllegalArgumentException("Cannot convert Alarm state " + state + " to an AlertState");
    }

    private static Level getLogLevel(DataProviderState state) {
        switch (state) {
            case ALARM: {
                return Level.SEVERE;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case NOMINAL: {
                return Level.INFO;
            }
        }
        throw new IllegalArgumentException("Cannot convert Alarm state " + state + " to an log Level");
    }
}

