package org.lsst.ccs.localdb.statusdb;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.hibernate.SessionFactory;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusAlert;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusData;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.localdb.configdb.ConfigurationPersister;
import org.lsst.ccs.localdb.statusdb.utils.CacheStatistics;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * Subsystem wrapper around a StatusDataPersister object
 */
public class StatusPersisterSubsystem extends Subsystem {
    private final Logger log = Logger.getLogger("org.lsst.ccs.localdb");

    private StatusDataPersister dataStatusBatchPersister ;
    
    private StatusPersister statusPersister;
    
    private  ConfigurationPersister configurationPersister;
    
    private static SessionFactory fac;
    
    
    public static synchronized void init(Properties p) {
        fac = StatusdbUtils.getSessionFactory(p);
    }
    
    public StatusPersisterSubsystem() {
        this(BootstrapResourceUtils.getBootstrapSystemProperties());
    }
    
    public StatusPersisterSubsystem(Properties p) {
        super("localdb", AgentInfo.AgentType.SERVICE);

        if (p == null) {
            p = new Properties(); 
        }
        init(p);
        
    }
    
    
    
    @Override
    public void startAgent() {
        dataStatusBatchPersister = new StatusDataPersister(fac, getAlertService());

        // TODO : modify
        configurationPersister = new ConfigurationPersister(this, fac);
        addCommandsFromObject(configurationPersister, "configuration-server");
        
        statusPersister = new StatusPersister(fac, configurationPersister, getAlertService());

        super.startAgent();
        
        configurationPersister.start();
        getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(statusPersister);
        getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(configurationPersister);
        getMessagingAccess().addStatusMessageListener(dataStatusBatchPersister,BusMessageFilterFactory.messageClass(StatusData.class).and(BusMessageFilterFactory.messageOrigin(null)));
        getMessagingAccess().addStatusMessageListener(statusPersister,
                BusMessageFilterFactory.messageOrigin(null).and(
                        BusMessageFilterFactory.messageClass(StatusAlert.class)
                                .or(BusMessageFilterFactory.messageClass(StatusStateChangeNotification.class)
                                        .or(BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class))
                                        .and( bm -> bm.getOriginAgentInfo().getType().compareTo(AgentInfo.AgentType.WORKER) >=0
                                        ))
                ));
        getScheduler().scheduleWithFixedDelay(dataStatusBatchPersister, 0, 1, TimeUnit.SECONDS);
        getScheduler().scheduleWithFixedDelay(statusPersister, 0, 1, TimeUnit.SECONDS);
        getScheduler().scheduleWithFixedDelay(dataStatusBatchPersister.getStatAccumulator(), 0, 1, TimeUnit.SECONDS);
        getScheduler().scheduleAtFixedRate(
                () -> {
                    publishSubsystemDataOnStatusBus(new KeyValueData("statistics", new CacheStatistics(fac)));
                }
                , 1, 5, TimeUnit.MINUTES);
        log.info(getName() + " started");
    }
    
//    public static void main(String[] args) {
//        Properties p = new Properties();
//        parseArgs(args, p);
//        StatusPersisterSubsystem system = new StatusPersisterSubsystem(p);
//        system.start() ;
//    }
    
    
//    private static void parseArgs(String[] args, Properties p) {
//        // define the command line options
//        Options commandLineOptions = new Options();
//        // The help option
//        commandLineOptions.addOption("h", "help", false, "Print the help message");
//        // The name of the description file.
//        commandLineOptions.addOption("u", "update", false,
//                "Start the Trending Ingest Module in update mode.");
//
//        CommandLineParser parser = new BasicParser();
//        try {
//            CommandLine line = parser.parse(commandLineOptions, args, false);
//            
//            if (line.hasOption("help")) {
//                usage(commandLineOptions);
//            } else {
//                if ( line.hasOption("update") ) {
//                    p.setProperty("hibernate.hbm2ddl.auto", "update");
//                }
//            }
//
//        } catch (Exception e) {
//            usage(commandLineOptions);
//        }
//
//    }

    static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "TrendingIngestModule", "", options, "", true);
        System.exit(0);
    }
    
    
}
