/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.command.AllowedValuesProvider;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryHelpGenerator;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.MethodBasedDictionaryArgument;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

public class HelpGenerator
implements AllowedValuesProvider {
    private final Dictionary dict;
    private final PrintWriter out;
    private CommandSet cmdSet = null;
    private final HelpCommands builtIns = new HelpCommands();

    public HelpGenerator(PrintWriter out, Dictionary dict) {
        this.out = out;
        this.dict = dict;
    }

    void help() {
        this.builtIns.help();
    }

    void help(String command) {
        this.builtIns.help(command);
    }

    public CommandSet getCommandSet() {
        if (this.cmdSet == null) {
            CommandSetBuilder builder = new CommandSetBuilder();
            this.cmdSet = builder.buildCommandSet(this.builtIns);
            for (DictionaryCommand setCommand : this.cmdSet.getCommandDictionary()) {
                if (setCommand.getArguments().length != 1) continue;
                MethodBasedDictionaryArgument helpArg = (MethodBasedDictionaryArgument)setCommand.getArguments()[0];
                helpArg.setAllowedValuesProvder(this);
                break;
            }
        }
        return this.cmdSet;
    }

    @Override
    public List<String> getAllowedValues() {
        ArrayList<String> allowedValues = new ArrayList<String>();
        for (DictionaryCommand cmd : this.dict) {
            String cmdName = cmd.getCommandName();
            if (allowedValues.contains(cmdName)) continue;
            allowedValues.add(cmdName);
        }
        return allowedValues;
    }

    private class HelpCommands {
        private HelpCommands() {
        }

        @Command(description="List available commands")
        public void help() {
            HelpGenerator.this.out.printf("%s", DictionaryUtils.basicHelpForDictionary(HelpGenerator.this.dict));
        }

        @Command(description="Show help for a single command")
        public void help(@Argument(name="command") String command) {
            boolean foundCommand = false;
            DictionaryHelpGenerator helpGenerator = HelpGenerator.this.dict.getHelpGenerator();
            for (DictionaryCommand def : HelpGenerator.this.dict) {
                if (!def.getCommandName().equals(command)) continue;
                foundCommand = true;
                String help = DictionaryUtils.basicHelpForCommand(def);
                int maxNameLeng = 0;
                int maxTypeLeng = 0;
                for (DictionaryArgument param : def.getArguments()) {
                    int leng = param.getName().length();
                    maxNameLeng = leng > maxNameLeng ? leng : maxNameLeng;
                    leng = param.getSimpleType().length();
                    maxTypeLeng = leng > maxTypeLeng ? leng : maxTypeLeng;
                }
                String spaces = String.format("%80s", "");
                for (DictionaryArgument param : def.getArguments()) {
                    if (param.getAllowedValues().size() == 1) continue;
                    String name = param.getName();
                    String type = param.getSimpleType();
                    help = help + "    " + name + spaces.substring(0, maxNameLeng - name.length()) + "   " + type + spaces.substring(0, maxTypeLeng - type.length()) + "   " + param.getDescription() + "\n";
                }
                if (helpGenerator != null && helpGenerator.hasHelp(def)) {
                    help = helpGenerator.modifyHelpForCommand(def, help, false);
                }
                HelpGenerator.this.out.printf("%s", help);
            }
            if (!foundCommand) {
                throw new IllegalArgumentException("No help found for " + command);
            }
        }
    }
}

