/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.utilities.logging.Logger;

class ConfigurationWriterProvider {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.config");
    private final WriterProvider wp = WriterProvider.getInstance();
    private static final String GLOBAL_PREFIX = "configGlobal_";
    private final String agentName;
    private final String descriptionName;

    ConfigurationWriterProvider(String agentName) {
        this.agentName = agentName;
        this.descriptionName = "null";
    }

    @Deprecated
    ConfigurationWriterProvider(String agentName, String descriptionName) {
        this.agentName = agentName;
        this.descriptionName = descriptionName;
    }

    public PrintWriter getConfigurationWriter(String tagName, String categoryName) throws IOException {
        String newName;
        String oldName = new ConfigurationFileName(this.descriptionName, tagName, categoryName).getFullName();
        if (oldName.equals(newName = new ConfigurationFileName(this.agentName, tagName, categoryName).getFullName()) || this.wp.getProperties(oldName) == null) {
            return this.wp.getPrintWriter(newName);
        }
        log.warn((Object)("the configuration properties file \"" + oldName + "\" should be removed or renamed \"" + newName + "\""));
        return this.wp.getPrintWriter(oldName);
    }

    public Properties getConfigurationProperties(String tagName, String categoryName) throws IOException {
        String newName;
        String oldName = new ConfigurationFileName(this.descriptionName, tagName, categoryName).getFullName();
        if (oldName.equals(newName = new ConfigurationFileName(this.agentName, tagName, categoryName).getFullName())) {
            return this.wp.getProperties(newName);
        }
        Properties props = this.wp.getProperties(oldName);
        if (props != null) {
            log.warn((Object)("the configuration properties file \"" + oldName + "\" should be removed or renamed \"" + newName + "\""));
            return props;
        }
        return this.wp.getProperties(newName);
    }

    public Set<String> findMatchingConfigurations(String category) {
        String pattern = this.agentName;
        pattern = category.isEmpty() ? pattern + "(_[^_]+?)??" : pattern + "_.*?_" + category;
        pattern = pattern + "\\.properties";
        Set<String> fullNames = this.wp.findMatchingPropertiesFiles(pattern);
        return fullNames.stream().map(s -> new ConfigurationFileName(this.agentName, (String)s).configName).collect(Collectors.toSet());
    }

    public String getNamedConfiguration(String name) throws IOException {
        Properties props = this.wp.getProperties(GLOBAL_PREFIX + this.agentName);
        if (props != null) {
            return props.getProperty(name);
        }
        return null;
    }

    public void setNamedConfiguration(ConfigurationDescription configDesc) throws IOException {
        Properties props = this.wp.getProperties(GLOBAL_PREFIX + this.agentName);
        if (props == null) {
            props = new Properties();
        }
        props.put(configDesc.getName(), configDesc.toString());
        PrintWriter pw = this.wp.getPrintWriter(GLOBAL_PREFIX + this.agentName);
        for (String prop : props.stringPropertyNames()) {
            pw.println(prop + "=" + (String)props.get(prop));
        }
        pw.flush();
        pw.close();
    }

    static class ConfigurationFileName {
        private final String tagName;
        private final String configName;
        private final String catName;
        private final String fullName;

        ConfigurationFileName(String tagName, String configName, String categoryName) {
            this.tagName = tagName;
            this.configName = configName;
            this.catName = categoryName;
            String baseName = tagName;
            if (configName.isEmpty()) {
                if (!this.catName.isEmpty()) {
                    baseName = baseName + "__" + this.catName;
                }
            } else {
                baseName = baseName + "_" + configName;
                if (!this.catName.isEmpty()) {
                    baseName = baseName + "_" + this.catName;
                }
            }
            this.fullName = baseName + ".properties";
        }

        ConfigurationFileName(String tagName, String fullName) {
            this.tagName = tagName;
            String trimmed = fullName.replace(".properties", "").replace(this.tagName, "");
            String[] split = trimmed.split("_");
            switch (split.length) {
                case 1: {
                    this.configName = "";
                    this.catName = "";
                    break;
                }
                case 2: {
                    this.configName = split[1];
                    this.catName = "";
                    break;
                }
                case 3: {
                    this.configName = split[1];
                    this.catName = split[2];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("file name is not a configuration file name : " + fullName);
                }
            }
            this.fullName = fullName;
        }

        public String getFullName() {
            return this.fullName;
        }
    }
}

