/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;

public class SubsystemBoot {
    static String[] descriptionNames;
    static String[] configurationFileNames;
    static String[] subsystemAliases;

    public static void main(String[] args) throws Exception {
        SubsystemBoot.parseArgsCLI(args);
        if (descriptionNames != null) {
            int numberOfAgents = descriptionNames.length;
            if (numberOfAgents == 0) {
                throw new IllegalArgumentException("Something went wrong. There must be at least one description: " + numberOfAgents);
            }
            if (configurationFileNames != null && configurationFileNames.length != numberOfAgents) {
                throw new IllegalArgumentException("Wrong number of arguments passed to option configuration: " + configurationFileNames.length + ". It must be either empty or the same as the number of descriptions: " + numberOfAgents);
            }
            if (subsystemAliases != null && subsystemAliases.length != numberOfAgents) {
                throw new IllegalArgumentException("Wrong number of arguments passed to option alias: " + subsystemAliases.length + ". It must be either empty or the same as the number of descriptions: " + numberOfAgents);
            }
            for (int i = 0; i < numberOfAgents; ++i) {
                String descriptionName = descriptionNames[i];
                String configurationFileName = configurationFileNames != null ? configurationFileNames[i] : null;
                try {
                    Subsystem a = BootUtils.getSubsystemFromFile(descriptionName, configurationFileName);
                    String agentAlias = subsystemAliases != null ? (subsystemAliases[i].isEmpty() ? null : subsystemAliases[i]) : null;
                    a.startAgent(agentAlias);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to start subsystem with description: " + descriptionName, e);
                }
            }
        } else {
            throw new IllegalArgumentException("no description has been specified");
        }
    }

    static void parseArgsCLI(String[] args) {
        Options commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        commandLineOptions.addOption("v", "verbose", false, "Turns on verbose statements");
        commandLineOptions.addOption("d", "description", true, "Name of Subsystem description file.");
        commandLineOptions.getOption("description").setArgName("DESCRIPTION_FILE");
        commandLineOptions.addOption("c", "configuration", true, "Name of Configuration properties file.");
        commandLineOptions.getOption("configuration").setArgName("CONFIGURATION_FILE");
        commandLineOptions.addOption("a", "alias", true, "Name of subsystem on the buses.");
        commandLineOptions.getOption("alias").setArgName("SUBSYSTEM_NAME");
        commandLineOptions.getOption("description").setArgs(-2);
        commandLineOptions.getOption("configuration").setArgs(-2);
        commandLineOptions.getOption("alias").setArgs(-2);
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(commandLineOptions, args, false);
            if (line.hasOption("help")) {
                SubsystemBoot.usageCLI(commandLineOptions);
            } else {
                descriptionNames = line.getOptionValues("description");
                configurationFileNames = line.getOptionValues("configuration");
                subsystemAliases = line.getOptionValues("alias");
            }
        }
        catch (Exception e) {
            SubsystemBoot.usageCLI(commandLineOptions);
        }
    }

    static void usageCLI(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "SubsystemBoot", "", options, "", true);
        System.exit(0);
    }

    static {
        subsystemAliases = null;
    }
}

