/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.utilities.logging.Logger;

final class LookupInjectUtils {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.lookupInject");

    private LookupInjectUtils() {
    }

    static void injectComponents(ComponentLookup lookup) {
        TreeWalkerUtils.proceduralBiWalk(lookup, null, Object.class, (n, target) -> {
            try {
                for (Class<?> cls = target.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
                    Field[] fields;
                    for (Field field : fields = cls.getDeclaredFields()) {
                        if (field.isAnnotationPresent(LookupField.class)) {
                            Class<?> fieldClass = field.getType();
                            if (Collection.class.isAssignableFrom(fieldClass) || Map.class.isAssignableFrom(fieldClass) || fieldClass.isArray()) {
                                LookupInjectUtils.setCollection(lookup, n.getKey(), target, field);
                            } else {
                                LookupInjectUtils.setSingleElement(lookup, n, n.getKey(), field);
                            }
                        }
                        if (!field.getType().equals(String.class) || !field.isAnnotationPresent(LookupName.class)) continue;
                        field.setAccessible(true);
                        field.set(target, n.getKey());
                        field.setAccessible(false);
                    }
                }
            }
            catch (Exception ex) {
                log.warn((Object)("At node : " + n.getKey() + " : " + ex.getMessage()), (Throwable)ex);
                throw ex instanceof RuntimeException ? (RuntimeException)ex : new IllegalArgumentException(ex);
            }
        }, null);
    }

    private static void setSingleElement(ComponentLookup lookup, ComponentNode node, String nodeName, Field f) throws IllegalAccessException {
        LookupField lf = f.getAnnotation(LookupField.class);
        Object toInject = null;
        Class<?> fieldClass = f.getType();
        block0 : switch (lf.strategy()) {
            case TOP: {
                toInject = lookup.getTopComponentNode().getComponent();
                break;
            }
            case ANCESTORS: {
                ComponentNode n = node;
                while (n.getParent() != null) {
                    if (!fieldClass.isAssignableFrom((n = n.getParent()).getComponent().getClass())) continue;
                    toInject = n.getComponent();
                    break block0;
                }
                break;
            }
            case SIBLINGS: {
                ComponentNode p = node.getParent();
                if (p == null) break;
                List siblings = p.getChildren();
                for (ComponentNode c : siblings) {
                    if (c.getKey().equals(node.getKey()) || !fieldClass.isAssignableFrom(c.getComponent().getClass())) continue;
                    toInject = c.getComponent();
                    break block0;
                }
                break;
            }
            case CHILDREN: {
                List children = node.getChildren();
                for (ComponentNode c : children) {
                    if (!fieldClass.isAssignableFrom(c.getComponent().getClass())) continue;
                    toInject = c.getComponent();
                    break block0;
                }
                break;
            }
            case DESCENDANTS: {
                toInject = LookupInjectUtils.treeWalkForSingleComponent(lookup, nodeName, fieldClass);
                break;
            }
            case TREE: {
                toInject = LookupInjectUtils.treeWalkForSingleComponent(lookup, lookup.getTopComponentNode().getKey(), fieldClass);
                break;
            }
            case BYNAME: {
                toInject = lookup.getComponentByName(f.getName());
                break;
            }
        }
        if (toInject == null) {
            log.fine((Object)("lookup strategy " + lf.strategy() + " failed for field " + f.getName() + " of node " + nodeName));
        } else {
            f.setAccessible(true);
            f.set(node.getComponent(), toInject);
            f.setAccessible(false);
        }
    }

    private static Object treeWalkForSingleComponent(ComponentLookup lookup, String startNode, Class fieldClass) {
        Object[] obj = new Object[1];
        TreeWalkerUtils.treeBiWalk(lookup, startNode, fieldClass, (n, o) -> {
            if (!n.getKey().equals(startNode)) {
                obj[0] = n.getComponent();
                return TreeWalkerDiag.STOP;
            }
            return TreeWalkerDiag.GO;
        }, null);
        return obj[0];
    }

    /*
     * WARNING - void declaration
     */
    private static void setCollection(ComponentLookup lookup, String from, Object obj, Field f) throws IllegalAccessException {
        Class<Object> elemClass;
        LookupField lf = f.getAnnotation(LookupField.class);
        ArrayList<Object> extractedObjects = new ArrayList<Object>();
        Type type = f.getGenericType();
        Class<?> cls = f.getType();
        if (type instanceof ParameterizedType) {
            Type[] typeArgs = ((ParameterizedType)type).getActualTypeArguments();
            elemClass = (Class<Object>)typeArgs[typeArgs.length - 1];
        } else {
            elemClass = cls.isArray() ? cls.getComponentType() : Object.class;
        }
        switch (lf.strategy()) {
            case DESCENDANTS: {
                TreeWalkerUtils.proceduralBiWalk(lookup, from, elemClass, (n, o) -> {
                    if (!n.getKey().equals(from)) {
                        extractedObjects.add(o);
                    }
                }, null);
                break;
            }
            case CHILDREN: {
                extractedObjects.addAll(lookup.listChildren(from, (Class)elemClass));
                break;
            }
            case SIBLINGS: {
                ComponentNode parent = lookup.getNodeByName(from).getParent();
                if (parent == null) break;
                List siblings = parent.getChildren();
                for (ComponentNode s : siblings) {
                    if (s.getKey().equals(from) || !elemClass.isAssignableFrom(s.getComponent().getClass())) continue;
                    extractedObjects.add(s.getComponent());
                }
                break;
            }
            case TREE: {
                TreeWalkerUtils.proceduralBiWalk(lookup, null, elemClass, (n, o) -> extractedObjects.add(o), null);
                break;
            }
            case ANCESTORS: {
                void var11_13;
                ComponentNode componentNode = lookup.getNodeByName(from).getParent();
                while (var11_13 != null) {
                    if (elemClass.isAssignableFrom(var11_13.getComponent().getClass())) {
                        extractedObjects.add(var11_13.getComponent());
                    }
                    ComponentNode componentNode2 = var11_13.getParent();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("strategy " + lf.strategy() + " incompatible with field type : " + cls);
            }
        }
        if (!extractedObjects.isEmpty()) {
            log.fine((Object)("lookup strategy " + lf.strategy() + " collected " + extractedObjects.size() + " elements for field " + f.getName() + " of node " + from));
            f.setAccessible(true);
            if (Map.class.isAssignableFrom(cls)) {
                Map mapObj = (Map)f.get(obj);
                for (Object e : extractedObjects) {
                    mapObj.put(lookup.getNameOfComponent(e), e);
                }
            } else if (List.class.isAssignableFrom(cls) || Set.class.isAssignableFrom(cls)) {
                Collection colObj = (Collection)f.get(obj);
                colObj.addAll(extractedObjects);
            } else if (cls.isArray()) {
                f.set(obj, extractedObjects.toArray((Object[])Array.newInstance(elemClass, extractedObjects.size())));
            }
            f.setAccessible(false);
        } else {
            log.fine((Object)("lookup strategy " + lf.strategy() + " collected no elements for field " + f.getName() + " of node " + from));
        }
    }
}

