/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.hibernate.SessionFactory;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusAlert;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusData;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.localdb.configdb.ConfigurationPersister;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.StatusPersister;
import org.lsst.ccs.localdb.statusdb.utils.CacheStatistics;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class StatusPersisterSubsystem
extends Subsystem {
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb");
    private StatusDataPersister dataStatusBatchPersister;
    private StatusPersister statusPersister;
    private ConfigurationPersister configurationPersister;
    private static SessionFactory fac;

    public static synchronized void init(Properties p) {
        fac = StatusdbUtils.getSessionFactory((Properties)p);
    }

    public StatusPersisterSubsystem() {
        this(BootstrapResourceUtils.getBootstrapSystemProperties());
    }

    public StatusPersisterSubsystem(Properties p) {
        super("localdb", AgentInfo.AgentType.SERVICE);
        if (p == null) {
            p = new Properties();
        }
        StatusPersisterSubsystem.init(p);
    }

    public void startAgent() {
        this.dataStatusBatchPersister = new StatusDataPersister(fac, this.getAlertService());
        this.configurationPersister = new ConfigurationPersister((Agent)this, fac);
        this.addCommandsFromObject(this.configurationPersister, "configuration-server");
        this.statusPersister = new StatusPersister(fac, this.configurationPersister, this.getAlertService());
        super.startAgent();
        this.configurationPersister.start();
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.statusPersister);
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.configurationPersister);
        this.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.dataStatusBatchPersister, BusMessageFilterFactory.messageClass(StatusData.class).and(BusMessageFilterFactory.messageOrigin(null)));
        this.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.statusPersister, BusMessageFilterFactory.messageOrigin(null).and(BusMessageFilterFactory.messageClass(StatusAlert.class).or(BusMessageFilterFactory.messageClass(StatusStateChangeNotification.class).or(BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class)).and(bm -> bm.getOriginAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0))));
        this.getScheduler().scheduleWithFixedDelay((Runnable)this.dataStatusBatchPersister, 0L, 1L, TimeUnit.SECONDS);
        this.getScheduler().scheduleWithFixedDelay((Runnable)this.statusPersister, 0L, 1L, TimeUnit.SECONDS);
        this.getScheduler().scheduleWithFixedDelay((Runnable)this.dataStatusBatchPersister.getStatAccumulator(), 0L, 1L, TimeUnit.SECONDS);
        this.getScheduler().scheduleAtFixedRate(() -> this.publishSubsystemDataOnStatusBus(new KeyValueData("statistics", (Serializable)new CacheStatistics(fac))), 1L, 5L, TimeUnit.MINUTES);
        this.log.info((Object)(this.getName() + " started"));
    }

    static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "TrendingIngestModule", "", options, "", true);
        System.exit(0);
    }
}

