/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.utils;

import java.math.BigInteger;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.lsst.ccs.localdb.statusdb.model.AgentState;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.StateBundleDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;

public class MigrateAgentStates {
    public static void main(String[] args) throws SQLException {
        SessionFactory fac = StatusdbUtils.getSessionFactory(new Properties());
        Session sess = fac.openSession();
        SQLQuery somethingToMigrate = sess.createSQLQuery("select count(*) from ccs_agentSt_innerStDe_b");
        int toMigrate = ((BigInteger)somethingToMigrate.uniqueResult()).intValue();
        if (toMigrate == 0) {
            System.out.println("Nothing to migrate");
            sess.close();
        } else {
            System.out.println("There are " + toMigrate + " entries in the old bridge table to migrate");
            Transaction tx = sess.beginTransaction();
            List agentStates = sess.createQuery("from AgentState").list();
            for (AgentState as : agentStates) {
                List sbds = sess.createQuery("from StateBundleDesc sbd where sbd.agentDesc=:ad").setEntity("ad", (Object)as.getAgentDesc()).list();
                Map<String, InnerStateDesc> isds = as.getInnerStates();
                if (isds.isEmpty()) continue;
                StateBundleDesc matchingSBD = null;
                as.setInnerStates(new HashMap<String, InnerStateDesc>());
                for (StateBundleDesc sbd : sbds) {
                    if (!sbd.getComponentStates().equals(isds)) continue;
                    matchingSBD = sbd;
                    break;
                }
                if (matchingSBD == null) {
                    matchingSBD = new StateBundleDesc(as.getAgentDesc());
                    matchingSBD.setComponentStates(isds);
                    sess.persist((Object)matchingSBD);
                }
                as.getComponentStates().put("", matchingSBD);
            }
            tx.commit();
            sess.close();
        }
    }
}

