/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.trendServer;

import com.sun.jersey.spi.resource.Singleton;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.localdb.statusdb.model.AlertDesc;
import org.lsst.ccs.localdb.statusdb.model.BaseState;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.MetaDataData;
import org.lsst.ccs.localdb.statusdb.model.PlotData;
import org.lsst.ccs.localdb.statusdb.model.RaisedAlertData;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StateChangeNotificationData;
import org.lsst.ccs.localdb.statusdb.server.AlertEvent;
import org.lsst.ccs.localdb.statusdb.server.AlertInfo;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.StateChange;
import org.lsst.ccs.localdb.statusdb.server.StateInfo;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.server.TrendingPlotData;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.utilities.logging.Log4JConfiguration;
import org.lsst.ccs.utilities.logging.Logger;

@Path(value="/dataserver")
@Singleton
public class DataServer {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb");
    private final SessionFactory fac;

    public DataServer() {
        Properties p = new Properties();
        this.fac = StatusdbUtils.getSessionFactory(p);
        log.fine((Object)"Starting Data Server");
    }

    private List<DataChannel> getListOfChannels() {
        log.fine((Object)"Loading Channel Information");
        long start = System.currentTimeMillis();
        Session sess = this.fac.openSession();
        Query dataQuery = sess.createQuery("from DataDesc order by dataName");
        dataQuery.setReadOnly(true);
        List l = dataQuery.list();
        ArrayList<DataChannel> channels = new ArrayList<DataChannel>();
        double delta = (double)(System.currentTimeMillis() - start) / 1000.0;
        log.fine((Object)("Done with the query " + l.size() + " in " + delta + " seconds"));
        for (DataDesc d : l) {
            DataChannel dc = new DataChannel(d);
            dc.getMetadata().put("subsystem", d.getDataPath().getAgentName());
            dc.getMetadata().put("type", d.getDataType());
            channels.add(dc);
            log.debug((Object)("retrieving Data Channel path= " + dc.getPathAsString()));
        }
        sess.close();
        return channels;
    }

    @GET
    @Path(value="/data")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public List<Data> getData(@QueryParam(value="id") List<Long> ids, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2, @QueryParam(value="flavor") String flavor, @QueryParam(value="n") @DefaultValue(value="30") int nbins) {
        ArrayList<Data> result = new ArrayList<Data>();
        for (long id : ids) {
            Data d = this.getData(id, t1, t2, flavor, nbins);
            result.add(d);
        }
        return result;
    }

    @GET
    @Path(value="/data/{id}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Data getData(@PathParam(value="id") long id, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2, @QueryParam(value="flavor") String flavor, @QueryParam(value="n") @DefaultValue(value="30") int nbins) {
        boolean useStat = false;
        boolean useRaw = false;
        if ("stat".equals(flavor)) {
            useStat = true;
        } else if ("raw".equals(flavor)) {
            useRaw = true;
        } else {
            flavor = "unspecified";
        }
        if (t2 < 0L) {
            t2 = System.currentTimeMillis();
        }
        if (t1 < 0L) {
            t1 = t2 - 3600000L;
        }
        log.fine((Object)("request for data " + id + "[" + t1 + "," + t2 + "] " + flavor + " " + nbins));
        long rawId = id;
        if (useRaw) {
            log.debug((Object)"sending raw data");
            return this.exportRawData(rawId, t1, t2);
        }
        if (useStat) {
            StatDesc statSource = null;
            long statSourceN = -1L;
            Map<StatDesc, Long> stats = this.getAvailableStats(rawId, t1, t2);
            log.fine((Object)"stats :");
            for (Map.Entry<StatDesc, Long> s : stats.entrySet()) {
                log.debug((Object)("  " + s.getKey().getId() + " " + s.getKey().getTimeBinWidth() + " : " + s.getValue()));
                long n = s.getValue();
                if (n <= (long)(nbins / 2)) continue;
                if (statSource != null) {
                    if (n >= statSourceN) continue;
                    statSource = s.getKey();
                    statSourceN = n;
                    continue;
                }
                statSource = s.getKey();
                statSourceN = n;
            }
            if (statSource != null) {
                log.fine((Object)("sending stat from stat sampling " + statSource.getTimeBinWidth() + " nsamples " + statSourceN));
                return this.exportStatDataFromStat(statSource, t1, t2, nbins);
            }
        }
        log.debug((Object)"sending stat from raw");
        return this.exportStatDataFromRaw(rawId, t1, t2, nbins);
    }

    public List<ChannelMetaData> getMetadata(int channelId) {
        return this.getMetadata(channelId, -1L, -1L);
    }

    public List<ChannelMetaData> getMetadata(int channelId, long t1, long t2) {
        Session sess = this.fac.openSession();
        String queryStr = "from MetaDataData where dataDesc.id = :id ";
        if (t1 > -1L) {
            queryStr = queryStr + "and (endTime > :t1 or startTime = -1) ";
        }
        if (t2 > -1L) {
            queryStr = queryStr + "and startTime < :t2 ";
        }
        Query q = sess.createQuery(queryStr);
        q.setReadOnly(true);
        q.setParameter("id", (Object)channelId);
        if (t1 > -1L) {
            q.setParameter("t1", (Object)t1);
        }
        if (t2 > -1L) {
            q.setParameter("t2", (Object)t2);
        }
        List l = q.list();
        sess.close();
        ArrayList<ChannelMetaData> out = new ArrayList<ChannelMetaData>();
        for (MetaDataData md : l) {
            out.add(new ChannelMetaData(md));
        }
        return out;
    }

    @GET
    @Path(value="/channelinfo/{id}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public ChannelMetaData.ChannelMetadataList getMetadataList(@PathParam(value="id") long channelId) {
        long rawId = channelId;
        return new ChannelMetaData.ChannelMetadataList(this.getMetadata((int)rawId));
    }

    @GET
    @Path(value="/listchannels")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public DataChannel.DataChannelList getChannels() {
        return new DataChannel.DataChannelList(this.getListOfChannels());
    }

    @GET
    @Path(value="/listchannels/{subsystem}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public DataChannel.DataChannelList getChannels(@PathParam(value="subsystem") String subsystemName) {
        List<DataChannel> channels = this.getListOfChannels();
        ArrayList<DataChannel> subChannels = new ArrayList<DataChannel>();
        for (DataChannel dc : channels) {
            if (!dc.getPath()[0].equals(subsystemName)) continue;
            subChannels.add(dc);
        }
        return new DataChannel.DataChannelList(subChannels);
    }

    public DataChannel[] getChannels(String partialPath, int level) {
        return null;
    }

    public DataChannel[] getChannelsByKeywork(String keyword) {
        return null;
    }

    protected Map<StatDesc, Long> getAvailableStats(long rawId, long t1, long t2) {
        Session sess = this.fac.openSession();
        HashMap<StatDesc, Long> m = new HashMap<StatDesc, Long>();
        Query q = sess.createQuery("select d, count(x) from StatDesc d, StatData x where d.dataDesc.id = :id and x.statDesc = d and (x.statTimeInterval.endTime) >= :t1 and x.statTimeInterval.startTime <= :t2 group by d.id order by d.timeBinWidth");
        q.setReadOnly(true);
        q.setLong("id", rawId);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        List l = q.list();
        for (Object[] r : l) {
            if (r[0] == null) continue;
            m.put((StatDesc)r[0], (Long)r[1]);
        }
        sess.close();
        return m;
    }

    protected long getAvailableRawData(long rawId, long t1, long t2) {
        Session sess = this.fac.openSession();
        Query q = sess.createQuery("select count(r) from RawData r where r.dataDesc.id = :id and r.tstamp between :t1 and :t2 order by r.tstamp");
        q.setReadOnly(true);
        q.setParameter("id", (Object)rawId);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        long n = (Long)q.uniqueResult();
        sess.close();
        return n;
    }

    protected List<RawData> getRawData(long id, long t1, long t2) {
        Session sess = this.fac.openSession();
        Query q = sess.createQuery("from RawData r where r.dataDesc.id = :id and r.time between :t1 and :t2 order by r.time");
        q.setReadOnly(true);
        q.setParameter("id", (Object)id);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        List l = q.list();
        log.debug((Object)("retrieved raw data " + id + "[" + t1 + "," + t2 + "] : " + l.size()));
        sess.close();
        return l;
    }

    protected List<StatData> getStatData(StatDesc statDesc, long t1, long t2) {
        Session sess = this.fac.openSession();
        Query q = sess.createQuery("from StatData r where r.statDesc.id = :id and r.statTimeInterval.startTime >= :t1 and r.statTimeInterval.startTime <= :t2 order by r.statTimeInterval.startTime");
        q.setReadOnly(true);
        q.setParameter("id", (Object)statDesc.getId());
        q.setParameter("t1", (Object)(t1 - statDesc.getTimeBinWidth()));
        q.setParameter("t2", (Object)t2);
        List l = q.list();
        log.debug((Object)("retrieved stat data " + statDesc.getId() + "[" + t1 + "," + t2 + "] : " + l.size()));
        sess.close();
        return l;
    }

    protected Data exportRawData(long rawId, long t1, long t2) {
        List<RawData> l = this.getRawData(rawId, t1, t2);
        Data d = new Data();
        d.setMetaDataData(this.getMetadata((int)rawId, t1, t2));
        TrendingData[] data = new TrendingData[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            TrendingData dt;
            RawData r = l.get(i);
            data[i] = dt = new TrendingData();
            long tStamp = r.getTime();
            TrendingData.AxisValue axisValue = new TrendingData.AxisValue("time", tStamp);
            dt.setAxisValue(axisValue);
            TrendingData.DataValue[] dataValue = new TrendingData.DataValue[1];
            Double dd = r.getDoubleData();
            dataValue[0] = new TrendingData.DataValue("value", dd == null ? 0.0 : dd);
            dt.setDataValue(dataValue);
        }
        d.getTrendingResult().setTrendingDataArray(data);
        return d;
    }

    protected Data exportStatDataFromRaw(long rawId, long t1, long t2, int nsamples) {
        Session sess = this.fac.openSession();
        SQLQuery q = sess.createSQLQuery("select tlow, thigh, datasum/entries as mean,  case when entries > 1 then  sqrt((datasumsquared - datasum*datasum/entries)/(entries-1))  else 0.0 end as rms,  mindata, maxdata  from ( SELECT MIN(rd.time) AS tlow, MAX(rd.time) AS thigh,  SUM(rd.doubleData) AS datasum, SUM(rd.doubleData*rd.doubleData) AS datasumsquared,  min(rd.doubleData) as mindata, max(rd.doubleData) as maxdata,  count(1) AS entries from ccs_rawData rd where rd.dataDescId = :id and time >= :t1  and time <= :t2 group by floor(rd.time/:deltat) ) accumulated where entries > 0 ORDER BY tlow DESC");
        q.setReadOnly(true);
        long deltat = (t2 - t1) / (long)nsamples;
        q.setParameter("id", (Object)rawId);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        q.setParameter("deltat", (Object)deltat);
        List l = q.list();
        sess.close();
        ArrayList<TrendingData> trendingDataList = new ArrayList<TrendingData>();
        for (Object[] obj : l) {
            if (obj[2] == null) continue;
            long low = ((BigInteger)obj[0]).longValue();
            long high = ((BigInteger)obj[1]).longValue();
            TrendingData dt = new TrendingData();
            dt.setAxisValue(new TrendingData.AxisValue("time", (low + high) / 2L, low, high));
            TrendingData.DataValue[] dataValue = new TrendingData.DataValue[4];
            double value = (Double)obj[2];
            double rms = 0.0;
            if (obj[3] != null) {
                rms = (Double)obj[3];
            }
            double min = (Double)obj[4];
            double max = (Double)obj[5];
            dataValue[0] = new TrendingData.DataValue("value", value);
            dataValue[1] = new TrendingData.DataValue("rms", rms);
            dataValue[2] = new TrendingData.DataValue("min", min);
            dataValue[3] = new TrendingData.DataValue("max", max);
            dt.setDataValue(dataValue);
            trendingDataList.add(dt);
        }
        TrendingData[] trendingData = trendingDataList.toArray(new TrendingData[0]);
        Data d = new Data();
        d.setMetaDataData(this.getMetadata((int)rawId, t1, t2));
        d.getTrendingResult().setTrendingDataArray(trendingData);
        return d;
    }

    protected Data exportStatDataFromStat(StatDesc statDesc, long t1, long t2, int nsamples) {
        List<StatData> in = this.getStatData(statDesc, t1, t2);
        int n = in.size();
        int rebin = 1;
        int nout = n;
        if (n > nsamples * 3) {
            rebin = n / nsamples;
            nout = (n + rebin - 1) / rebin;
            log.debug((Object)("will rebin stat by " + rebin + " : " + nout));
        }
        Data d = new Data();
        d.setMetaDataData(this.getMetadata((int)statDesc.getDataDesc().getId(), t1, t2));
        d.getTrendingResult().setTrendingDataArray(new TrendingData[nout]);
        int iout = 0;
        int ibin = 0;
        double sum = 0.0;
        double s2 = 0.0;
        long nsamp = 0L;
        long low = 0L;
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        for (StatData sd : in) {
            if (ibin == 0) {
                sum = 0.0;
                s2 = 0.0;
                nsamp = 0L;
                low = sd.getStatTimeInterval().getStartTime();
                max = -1.7976931348623157E308;
                min = Double.MAX_VALUE;
            }
            sum += sd.getSum();
            s2 += sd.getSum2();
            if (sd.getMax() > max) {
                max = sd.getMax();
            }
            if (sd.getMin() < min) {
                min = sd.getMin();
            }
            nsamp += (long)sd.getN();
            if (ibin == rebin - 1 || iout * rebin + ibin == n - 1) {
                TrendingData dt;
                log.debug((Object)("storing for " + iout + " from " + (ibin + 1) + " bins"));
                d.getTrendingResult().getTrendingDataArray()[iout] = dt = new TrendingData();
                dt.setAxisValue(new TrendingData.AxisValue("time", (low + sd.getStatTimeInterval().getEndTime()) / 2L, low, sd.getStatTimeInterval().getEndTime()));
                TrendingData.DataValue[] dataValue = new TrendingData.DataValue[]{new TrendingData.DataValue("value", sum / (double)nsamp), new TrendingData.DataValue("rms", Math.sqrt(s2 / (double)nsamp - sum / (double)nsamp * (sum / (double)nsamp))), new TrendingData.DataValue("min", min), new TrendingData.DataValue("max", max)};
                dt.setDataValue(dataValue);
                ++iout;
                ibin = 0;
                continue;
            }
            ++ibin;
        }
        return d;
    }

    @GET
    @Path(value="liststates/{subsystem}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public StateInfo.StateInfoList getStateInfo(@PathParam(value="subsystem") String subsystem) {
        Session sess = this.fac.openSession();
        ArrayList<StateInfo> res = new ArrayList<StateInfo>();
        Query q = sess.createQuery("from BaseState bs").setReadOnly(true);
        List bsl = q.list();
        HashMap<Class<OperationalState>, StateInfo> baseStateInfoMap = new HashMap<Class<OperationalState>, StateInfo>();
        baseStateInfoMap.put(AlertState.class, new StateInfo(AlertState.class.getName()));
        baseStateInfoMap.put(ConfigurationState.class, new StateInfo(ConfigurationState.class.getName()));
        baseStateInfoMap.put(CommandState.class, new StateInfo(CommandState.class.getName()));
        baseStateInfoMap.put(PhaseState.class, new StateInfo(PhaseState.class.getName()));
        baseStateInfoMap.put(OperationalState.class, new StateInfo(OperationalState.class.getName()));
        for (BaseState bs : bsl) {
            ((StateInfo)baseStateInfoMap.get(AlertState.class)).getStateValues().add(bs.getAlertState());
            ((StateInfo)baseStateInfoMap.get(ConfigurationState.class)).getStateValues().add(bs.getConfigState());
            ((StateInfo)baseStateInfoMap.get(CommandState.class)).getStateValues().add(bs.getCommandState());
            ((StateInfo)baseStateInfoMap.get(PhaseState.class)).getStateValues().add(bs.getPhaseState());
            ((StateInfo)baseStateInfoMap.get(OperationalState.class)).getStateValues().add(bs.getOperationalState());
        }
        for (StateInfo si : baseStateInfoMap.values()) {
            res.add(si);
        }
        q = sess.createQuery("from InnerStateDesc isd where isd.agentDesc.agentName=:agentName").setString("agentName", subsystem).setReadOnly(true);
        HashMap<String, StateInfo> innerStateInfoMap = new HashMap<String, StateInfo>();
        List isdl = q.list();
        for (InnerStateDesc isd : isdl) {
            String isdClassName = isd.getEnumClassName();
            StateInfo si = (StateInfo)innerStateInfoMap.get(isdClassName);
            if (si == null) {
                si = new StateInfo(isdClassName);
                innerStateInfoMap.put(isdClassName, si);
            }
            si.getStateValues().add(isd.getEnumValue());
        }
        for (StateInfo si : innerStateInfoMap.values()) {
            res.add(si);
        }
        sess.close();
        return new StateInfo.StateInfoList(res);
    }

    @GET
    @Path(value="/statechanges/{subsystem}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public StateChange.StateChangesList getStateChangeList(@PathParam(value="subsystem") String subsystem, @QueryParam(value="state") List<String> states, @QueryParam(value="component") List<String> components, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2) {
        return this.innerGetStateChangeList(subsystem, components, states, t1, t2);
    }

    @GET
    @Path(value="/statechanges/{subsystem}/{component}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public StateChange.StateChangesList getComponentStateChangeList(@PathParam(value="subsystem") String subsystem, @PathParam(value="component") String component, @QueryParam(value="state") List<String> states, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2) {
        return this.innerGetStateChangeList(subsystem, Arrays.asList(component), states, t1, t2);
    }

    private StateChange.StateChangesList innerGetStateChangeList(String subsystem, List<String> components, List<String> states, long t1, long t2) {
        List<StateChangeNotificationData> stateChangeNotifications;
        if (t2 < 0L) {
            t2 = System.currentTimeMillis();
        }
        if (t1 < 0L) {
            t1 = t2 - 3600000L;
        }
        if ((stateChangeNotifications = this.getStateChanges(subsystem, t1, t2)).isEmpty()) {
            return new StateChange.StateChangesList();
        }
        ArrayList<StateChange> stateChanges = new ArrayList<StateChange>();
        StateChangeNotificationData firstSCND = stateChangeNotifications.get(0);
        Map<String, Map<String, String>> origStates = null;
        origStates = firstSCND.getTime() <= t1 ? firstSCND.getNewState().asFlatStatesMap(components) : firstSCND.getOldState().asFlatStatesMap(components);
        StateChange sc = new StateChange();
        sc.setTime(t1);
        for (Map.Entry<String, Map<String, String>> e1 : origStates.entrySet()) {
            for (Map.Entry<String, String> e2 : e1.getValue().entrySet()) {
                if (states != null && !states.isEmpty() && !states.contains(e2.getKey())) continue;
                sc.addStateEvent(e1.getKey(), e2.getKey(), e2.getValue());
            }
        }
        stateChanges.add(sc);
        StateChange originSE = sc;
        for (StateChangeNotificationData scnd : stateChangeNotifications) {
            if (scnd.getTime() <= t1) continue;
            sc = new StateChange();
            Map<String, Map<String, String>> oldState = scnd.getOldState().asFlatStatesMap(components);
            Map<String, Map<String, String>> newState = scnd.getNewState().asFlatStatesMap(components);
            for (Map.Entry<String, Map<String, String>> e1 : newState.entrySet()) {
                String component = e1.getKey();
                for (Map.Entry<String, String> e2 : e1.getValue().entrySet()) {
                    Map<String, String> prevCompStates;
                    String enumClassName = e2.getKey();
                    String enumValue = e2.getValue();
                    if (states != null && !states.isEmpty() && !states.contains(enumClassName) || (prevCompStates = oldState.get(component)) != null && enumValue.equals(prevCompStates.get(enumClassName))) continue;
                    sc.addStateEvent(component, enumClassName, enumValue);
                    if (originSE.containsEvent(component, enumClassName)) continue;
                    originSE.addStateEvent(component, enumClassName, "_UNDEF_");
                }
            }
            if (sc.isEmpty()) continue;
            sc.setTime(scnd.getTime());
            stateChanges.add(sc);
        }
        return new StateChange.StateChangesList(stateChanges);
    }

    private List<StateChangeNotificationData> getStateChanges(String subsystemName, long t1, long t2) {
        Session sess = this.fac.openSession();
        Query q = sess.createQuery("from StateChangeNotificationData scnd where scnd.agentDesc.agentName=:name and scnd.time >:t1 and scnd.time <=:t2").setString("name", subsystemName).setLong("t1", t1).setLong("t2", t2).setReadOnly(true);
        List res = q.list();
        if (res.isEmpty()) {
            q = sess.createQuery("from StateChangeNotificationData scnd where scnd.agentDesc.agentName=:name and scnd.time <=:t1 order by scnd.time desc").setString("name", subsystemName).setLong("t1", t1).setMaxResults(1).setReadOnly(true);
            res = q.list();
        }
        sess.close();
        return res;
    }

    @Path(value="/listalerts")
    @GET
    public AlertInfo.AlertInfoList getAlertInfo() {
        return this.getAlertInfo(null);
    }

    @Path(value="/listalerts/{subsystem}")
    @GET
    public AlertInfo.AlertInfoList getAlertInfo(@PathParam(value="subsystem") String subsystem) {
        Session sess = this.fac.openSession();
        Query q = subsystem == null ? sess.createQuery("from AlertDesc ad") : sess.createQuery("from AlertDesc ad where ad.agentDesc.agentName=:name").setString("name", subsystem);
        q.setReadOnly(true);
        List l = q.list();
        ArrayList<AlertInfo> res = new ArrayList<AlertInfo>();
        for (AlertDesc ad : l) {
            res.add(new AlertInfo(ad.getId(), ad.getAgentDesc().getAgentName(), ad.getAlertId(), ad.getAlertDescription()));
        }
        sess.close();
        return new AlertInfo.AlertInfoList(res);
    }

    @Path(value="activealerts")
    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public AlertEvent.AlertEventList getActiveAlerts(@QueryParam(value="id") List<Long> ids) {
        Session sess = this.fac.openSession();
        Query q = ids == null || ids.isEmpty() ? sess.createQuery("from RaisedAlertData arad where arad.active=true") : sess.createQuery("from RaisedAlertData arad where arad.alertDesc.id in (:ids) and arad.active=true").setParameterList("ids", ids).setReadOnly(true);
        q.setReadOnly(true);
        ArrayList<AlertEvent> res = new ArrayList<AlertEvent>();
        for (RaisedAlertData rad : q.list()) {
            AlertEvent ae = new AlertEvent(rad.getAlertDesc().getAlertId(), rad.getTime(), rad.getSeverity(), rad.getAlertCause());
            ae.setCleared(rad.getClearingAlert() != null);
            res.add(ae);
        }
        return new AlertEvent.AlertEventList(res);
    }

    @Path(value="alerthistory")
    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public AlertEvent.AlertEventList getAlertHistories(@QueryParam(value="id") List<Long> ids, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2) {
        if (t2 < 0L) {
            t2 = System.currentTimeMillis();
        }
        if (t1 < 0L) {
            t1 = t2 - 3600000L;
        }
        Session sess = this.fac.openSession();
        Query q = ids == null || ids.isEmpty() ? sess.createQuery("from RaisedAlertData arad") : sess.createQuery("from RaisedAlertData arad where arad.alertDesc.id in (:ids)").setParameterList("ids", ids).setReadOnly(true);
        q.setReadOnly(true);
        ArrayList<AlertEvent> res = new ArrayList<AlertEvent>();
        for (RaisedAlertData rad : q.list()) {
            AlertEvent ae = new AlertEvent(rad.getAlertDesc().getAlertId(), rad.getTime(), rad.getSeverity(), rad.getAlertCause());
            ae.setCleared(rad.getClearingAlert() != null);
            res.add(ae);
        }
        return new AlertEvent.AlertEventList(res);
    }

    @GET
    @Path(value="plotdata/{id}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public TrendingPlotData.TrendingPlotDataList getPlotData(@PathParam(value="id") long id, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2) {
        Session sess = this.fac.openSession();
        if (t2 < 0L) {
            t2 = System.currentTimeMillis();
        }
        if (t1 < 0L) {
            t1 = t2 - 3600000L;
        }
        Query q = sess.createQuery("from PlotData pd where pd.dataDesc.id=:id and pd.time >=:t1 and pd.time <=:t2").setLong("id", id).setLong("t1", t1).setLong("t2", t2).setReadOnly(true);
        List plotdata = q.list();
        ArrayList<TrendingPlotData> res = new ArrayList<TrendingPlotData>();
        for (PlotData pd : plotdata) {
            TrendingPlotData tpd = new TrendingPlotData();
            tpd.setId(id);
            tpd.setPlotData(pd.getPlotData());
            tpd.setTime(pd.getTime());
            res.add(tpd);
        }
        sess.close();
        return new TrendingPlotData.TrendingPlotDataList(res);
    }

    static {
        Log4JConfiguration.initialize();
    }
}

