/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.Transient;
import org.lsst.ccs.localdb.configdb.model.Configuration;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameterValue;
import org.lsst.ccs.localdb.configdb.model.GlobalConfiguration;
import org.lsst.ccs.localdb.configdb.model.PackCst;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;

@Entity
public class ConfigurationRun
implements Serializable {
    private static final long serialVersionUID = 927127673789827728L;
    private long id;
    private Configuration configuration;
    private Map<ParameterPath, ConfigurationParameterValue> runtimeChanges = new HashMap<ParameterPath, ConfigurationParameterValue>();
    private long tstart;
    private long tstop = PackCst.STILL_VALID;
    private GlobalConfiguration globalConfiguration;

    protected ConfigurationRun() {
    }

    public ConfigurationRun(long startTime) {
        this.tstart = startTime;
    }

    public ConfigurationRun(Configuration config, long startTime) {
        this(startTime);
        this.configuration = config;
    }

    public ConfigurationRun(ConfigurationRun other, long startTime) {
        this(other.configuration, startTime);
        for (ConfigurationParameterValue cpv : other.runtimeChanges.values()) {
            this.runtimeChanges.put(cpv.getPath(), cpv);
        }
    }

    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @ManyToMany(cascade={CascadeType.ALL})
    @MapKeyJoinColumn(name="configurationParameter_parameterPath")
    public Map<ParameterPath, ConfigurationParameterValue> getRuntimeChanges() {
        return this.runtimeChanges;
    }

    public void setRuntimeChanges(Map<ParameterPath, ConfigurationParameterValue> runtimeChanges) {
        this.runtimeChanges.putAll(runtimeChanges);
    }

    public void addRuntimeChange(ConfigurationParameterValue cpc) {
        this.runtimeChanges.put(cpc.getPath(), cpc);
    }

    public ConfigurationParameterValue getConfigurationParameterValueForRun(ParameterPath path) {
        if (this.runtimeChanges.containsKey(path)) {
            return this.runtimeChanges.get(path);
        }
        return this.configuration.getConfigurationParameterValues().get(path);
    }

    public long getTstart() {
        return this.tstart;
    }

    void setTstart(long tstart) {
        this.tstart = tstart;
    }

    public long getTstop() {
        return this.tstop;
    }

    public void setTstop(long tstop) {
        this.tstop = tstop;
    }

    @ManyToOne(optional=true, fetch=FetchType.EAGER)
    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public void setGlobalConfiguration(GlobalConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    @Transient
    public boolean isDirty() {
        return !this.runtimeChanges.isEmpty();
    }

    @Transient
    public String getConfigurationDescriptionString() {
        StringBuilder sb = new StringBuilder(this.configuration.getConfigurationDescriptionString());
        if (this.isDirty()) {
            sb.append("*");
        }
        return sb.toString();
    }
}

