/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.util.ArrayList;
import java.util.Properties;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.stat.CacheRegionStatistics;
import org.hibernate.stat.NaturalIdStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.Statistics;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.localdb.dao.LocaldbFacade;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StatTimeInterval;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class LocaldbFacadeTest
extends LocaldbTestTemplate {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.statusdb.model");

    @BeforeClass
    public static void setupClass() {
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
    }

    @Test
    public void testGetParallelStatTimeInterval() {
        StatusdbUtils.closeSessionFactory();
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        Statistics stats = sessionFactory.getStatistics();
        CacheRegionStatistics slCache = stats.getCacheRegionStatistics(StatTimeInterval.class.getName());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Session sess = sessionFactory.openSession();
                Transaction tx = sess.beginTransaction();
                long time = 0L;
                StatTimeInterval firstSti = null;
                for (int j = 0; j < 10; ++j) {
                    for (int i = 0; i < 1000; ++i) {
                        StatTimeInterval sti = LocaldbFacade.getStatTimeInterval((long)300000L, (long)(time + (long)(3000 * i)));
                        if (firstSti != null) continue;
                        firstSti = sti;
                    }
                }
                tx.commit();
                sess.close();
            }
        };
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 10; ++i) {
            threads.add(new Thread(r));
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Assert.assertEquals((long)10L, (long)slCache.getPutCount());
        Assert.assertTrue((slCache.getHitCount() > 0L ? 1 : 0) != 0);
        threads.clear();
        for (int i = 0; i < 10; ++i) {
            threads.add(new Thread(r));
        }
        for (Thread t : threads) {
            t.start();
            try {
                t.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Assert.assertEquals((long)10L, (long)slCache.getPutCount());
        Assert.assertTrue((slCache.getHitCount() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testGetStatTimeInterval() {
        StatTimeInterval sti;
        int i;
        StatusdbUtils.closeSessionFactory();
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        Statistics stats = sessionFactory.getStatistics();
        NaturalIdStatistics naturalCache = stats.getNaturalIdStatistics(StatTimeInterval.class.getName());
        CacheRegionStatistics slCache = stats.getCacheRegionStatistics(StatTimeInterval.class.getName());
        Session sess = sessionFactory.openSession();
        Transaction tx = sess.beginTransaction();
        Assert.assertEquals((String)"nothing in natural id cache", (long)0L, (long)naturalCache.getCacheHitCount());
        long time = 0L;
        StatTimeInterval firstSti = null;
        for (i = 0; i < 1000; ++i) {
            sti = LocaldbFacade.getStatTimeInterval((long)300000L, (long)(time + (long)i));
            if (firstSti == null) {
                firstSti = sti;
            }
            Assert.assertEquals((String)"stat time intervals should be equal", (Object)firstSti, (Object)sti);
        }
        tx.commit();
        sess.close();
        System.out.println(naturalCache);
        System.out.println(slCache);
        sess = sessionFactory.openSession();
        tx = sess.beginTransaction();
        firstSti = null;
        for (i = 0; i < 1000; ++i) {
            sti = LocaldbFacade.getStatTimeInterval((long)300000L, (long)(time + (long)i));
            if (firstSti == null) {
                firstSti = sti;
            }
            Assert.assertEquals((String)"stat time intervals should be equal", (Object)firstSti, (Object)sti);
        }
        tx.commit();
        sess.close();
        System.out.println(naturalCache);
        System.out.println(slCache);
        for (i = 0; i < 1000; ++i) {
            sess = sessionFactory.openSession();
            sti = LocaldbFacade.getStatTimeInterval((long)300000L, (long)(time + (long)i));
            sess.close();
        }
        System.out.println(naturalCache);
        System.out.println(slCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStatData() {
        Session sess = sessionFactory.openSession();
        try {
            sess.setFlushMode(FlushMode.COMMIT);
            Statistics stats = sessionFactory.getStatistics();
            CacheRegionStatistics slCache = stats.getCacheRegionStatistics(StatData.class.getName());
            CacheRegionStatistics tiSlCache = stats.getCacheRegionStatistics(StatTimeInterval.class.getName());
            QueryStatistics findDataStat = stats.getQueryStatistics("findStatData");
            Transaction tx = sess.beginTransaction();
            DataDesc dd = new DataDesc();
            dd.setDataPath(new DataPath("my-agent", "comp/mydata"));
            dd.setDataType("trending");
            sess.persist((Object)dd);
            StatDesc sd = new StatDesc();
            sd.setDataDesc(dd);
            sd.setTimeBinWidth(300000L);
            long startTime = System.currentTimeMillis();
            StatTimeInterval sti = LocaldbFacade.getStatTimeInterval((long)sd.getTimeBinWidth(), (long)startTime);
            sess.persist((Object)sd);
            tx.commit();
            sess.close();
            sess = sessionFactory.openSession();
            sess.setFlushMode(FlushMode.COMMIT);
            tx = sess.beginTransaction();
            sti = LocaldbFacade.getStatTimeInterval((long)sd.getTimeBinWidth(), (long)startTime);
            StatData stat = LocaldbFacade.getStatDataOrNull((StatDesc)sd, (StatTimeInterval)sti, (Session)sess);
            Assert.assertNull((Object)stat);
            RawData rd = new RawData();
            rd.setDataDesc(dd);
            rd.setDoubleData(Double.valueOf(Double.NaN));
            sess.persist((Object)rd);
            stat = new StatData(sd, rd.getDoubleData().doubleValue(), sti);
            sess.persist((Object)stat);
            StatData newStat = LocaldbFacade.getStatDataOrNull((StatDesc)sd, (StatTimeInterval)sti, (Session)sess);
            Assert.assertSame((Object)stat, (Object)newStat);
            tx.commit();
            sess.close();
            System.out.println("1 " + findDataStat);
            sess = sessionFactory.openSession();
            sess.setFlushMode(FlushMode.COMMIT);
            tx = sess.beginTransaction();
            sti = LocaldbFacade.getStatTimeInterval((long)sd.getTimeBinWidth(), (long)System.currentTimeMillis());
            stat = LocaldbFacade.getStatDataOrNull((StatDesc)sd, (StatTimeInterval)sti, (Session)sess);
            newStat = LocaldbFacade.getStatDataOrNull((StatDesc)sd, (StatTimeInterval)sti, (Session)sess);
            Assert.assertSame((Object)stat, (Object)newStat);
            tx.commit();
            sess.close();
            System.out.println("2 " + findDataStat);
            Assert.assertEquals((long)0L, (long)slCache.getHitCount());
            Assert.assertEquals((long)2L, (long)tiSlCache.getHitCount());
            sess = sessionFactory.openSession();
            sess.setFlushMode(FlushMode.COMMIT);
            tx = sess.beginTransaction();
            sti = LocaldbFacade.getStatTimeInterval((long)sd.getTimeBinWidth(), (long)System.currentTimeMillis());
            stat = LocaldbFacade.getStatDataOrNull((StatDesc)sd, (StatTimeInterval)sti, (Session)sess);
            newStat = LocaldbFacade.getStatDataOrNull((StatDesc)sd, (StatTimeInterval)sti, (Session)sess);
            Assert.assertSame((Object)stat, (Object)newStat);
            tx.commit();
            sess.close();
            for (int i = 0; i < 1000; ++i) {
                Session s = sessionFactory.openSession();
                StatData statData = LocaldbFacade.getStatDataOrNull((StatDesc)sd, (StatTimeInterval)sti, (Session)s);
                Assert.assertNotNull((Object)statData);
                s.close();
            }
            System.out.println("3 " + findDataStat);
            Assert.assertEquals((long)1001L, (long)slCache.getHitCount());
            Assert.assertEquals((long)1003L, (long)tiSlCache.getHitCount());
        }
        finally {
            if (sess.isOpen()) {
                sess.close();
            }
        }
    }
}

