/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.Cache;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.stat.CacheRegionStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.Statistics;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.localdb.dao.LocaldbFacade;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.model.AlertDesc;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;

public class MappingDiagramTest
extends LocaldbTestTemplate {
    @BeforeClass
    public static void initClass() {
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
    }

    @Test
    public void testAgentDescCache() throws Exception {
        StatusdbUtils.closeSessionFactory();
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        Statistics stats = sessionFactory.getStatistics();
        CacheRegionStatistics agentDescStats = stats.getCacheRegionStatistics(AgentDesc.class.getName());
        Session sess = sessionFactory.openSession();
        Transaction tx = sess.beginTransaction();
        Assert.assertEquals((long)0L, (long)agentDescStats.getHitCount());
        AgentInfo ai = new AgentInfo("agent1", AgentInfo.AgentType.WORKER);
        LocaldbFacade.getAgentDesc((AgentInfo)ai, (Session)sess);
        tx.commit();
        sess.close();
        Assert.assertEquals((long)1L, (long)agentDescStats.getMissCount());
        Assert.assertEquals((long)0L, (long)agentDescStats.getHitCount());
        sess = sessionFactory.openSession();
        tx = sess.beginTransaction();
        LocaldbFacade.getAgentDesc((AgentInfo)ai, (Session)sess);
        Cache cache = sessionFactory.getCache();
        Assert.assertTrue((boolean)cache.containsEntity(AgentDesc.class, (Serializable)((Object)ai.getName())));
        Assert.assertEquals((long)1L, (long)agentDescStats.getMissCount());
        Assert.assertEquals((long)1L, (long)agentDescStats.getHitCount());
        tx.commit();
        sess.close();
        sess = sessionFactory.openSession();
        tx = sess.beginTransaction();
        LocaldbFacade.getAgentDesc((AgentInfo)ai, (Session)sess);
        Assert.assertEquals((long)1L, (long)agentDescStats.getMissCount());
        Assert.assertEquals((long)2L, (long)agentDescStats.getHitCount());
        tx.commit();
        sess.close();
    }

    @Test
    public void testAlertDescCache() {
        StatusdbUtils.closeSessionFactory();
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        Session sess = sessionFactory.openSession();
        Statistics stats = sessionFactory.getStatistics();
        QueryStatistics agentDescStats = stats.getQueryStatistics(sess.getNamedQuery("findAlertDesc").getQueryString());
        sess.close();
        sess = sessionFactory.openSession();
        Transaction tx = sess.beginTransaction();
        AgentDesc agentDesc = LocaldbFacade.getAgentDesc((AgentInfo)new AgentInfo("agent_alertTest", AgentInfo.AgentType.WORKER), (Session)sess);
        Alert alert = new Alert("AL001", "Alert number one");
        AlertDesc ad = LocaldbFacade.getAlertDescOrPersist((AgentDesc)agentDesc, (Alert)alert, (Session)sess);
        tx.commit();
        sess.close();
        Assert.assertEquals((long)0L, (long)agentDescStats.getCacheHitCount());
        sess = sessionFactory.openSession();
        tx = sess.beginTransaction();
        LocaldbFacade.getAlertDescOrPersist((AgentDesc)agentDesc, (Alert)alert, (Session)sess);
        tx.commit();
        sess.close();
        Assert.assertEquals((long)0L, (long)agentDescStats.getCacheHitCount());
        sess = sessionFactory.openSession();
        tx = sess.beginTransaction();
        LocaldbFacade.getAlertDescOrPersist((AgentDesc)agentDesc, (Alert)alert, (Session)sess);
        tx.commit();
        sess.close();
        Assert.assertEquals((long)1L, (long)agentDescStats.getCacheHitCount());
    }

    @Test
    public void testDataDescCache() {
        StatusdbUtils.closeSessionFactory();
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        Session sess = sessionFactory.openSession();
        Statistics stats = sessionFactory.getStatistics();
        QueryStatistics dataDescStats = stats.getQueryStatistics(sess.getNamedQuery("findDataDesc").getQueryString());
        sess.close();
        sess = sessionFactory.openSession();
        Transaction tx = sess.beginTransaction();
        DataPath path = new DataPath("ag1", "q1");
        DataDesc dd = new DataDesc();
        dd.setDataType("");
        dd.setDataPath(path);
        sess.persist((Object)dd);
        tx.commit();
        sess.close();
        sess = sessionFactory.openSession();
        tx = sess.beginTransaction();
        DataDesc ddDB = (DataDesc)sess.getNamedQuery("findDataDesc").setString("agentName", path.getAgentName()).setString("dataName", path.getDataName()).uniqueResult();
        Assert.assertEquals((Object)path, (Object)ddDB.getDataPath());
        tx.commit();
        sess.close();
        Assert.assertEquals((long)0L, (long)dataDescStats.getCacheHitCount());
        sess = sessionFactory.openSession();
        tx = sess.beginTransaction();
        ddDB = (DataDesc)sess.getNamedQuery("findDataDesc").setString("agentName", path.getAgentName()).setString("dataName", path.getDataName()).uniqueResult();
        Assert.assertEquals((Object)path, (Object)ddDB.getDataPath());
        tx.commit();
        sess.close();
        Assert.assertEquals((long)1L, (long)dataDescStats.getCacheHitCount());
    }
}

