package org.lsst.ccs.localdb.utils;

import java.sql.SQLException;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * Migration utility for AgentState entities.
 *
 * It re-saves the object, which triggers a compute of md5 hash
 *
 * @author LSST CCS Team
 */
public class OptimizeAgentStates {
    
    private static Logger log = Logger.getLogger("org.lsst.ccs.localdb");
    
    public static void main(String[] args) throws SQLException {
//        
//        Properties p = new Properties();
//        
//        // Disable hbm2ddl
//        p.setProperty("hibernate.hbm2ddl.auto", "none");
//        
//        SessionFactory fac = StatusdbUtils.getSessionFactory(p);
//        
//        Session sess = fac.openSession();
//        
//        Transaction tx = sess.beginTransaction();
//        
//        // add direct SQL DDL to update the schema and add the two columns
//        
//        String sql = "ALTER TABLE ccs_agentState ADD (hashMD5 varbinary(100))";
//        SQLQuery sq = sess.createSQLQuery(sql);
//        try {
//            sq.executeUpdate();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        
//        sql = "ALTER TABLE ccs_stateBundleDesc ADD (hashMD5 varbinary(100))";
//        sq = sess.createSQLQuery(sql);
//        try {
//            sq.executeUpdate();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        
//        // Drop the foreign key is necessary to rename the column in certain versions of innodb
//        sql = "alter table ccs_stateBundleDesc drop foreign key ccs_stateBuDe_agentDeNa_agentDe_fk";
//        try {
//            sess.createSQLQuery(sql).executeUpdate();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        
//        // rename the column
//        sql = "ALTER TABLE ccs_stateBundleDesc CHANGE `agentDesc_agentName` `agentName` varchar(255) NOT NULL";
//        sq = sess.createSQLQuery(sql);
//        try {
//            sq.executeUpdate();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        
//        // add the foreign key back
//        sql = "alter table ccs_stateBundleDesc add constraint ccs_stateBuDe_agentDeNa_agentDe_fk foreign key (agentName) references ccs_agentDesc(agentName)";
//        try {
//            sess.createSQLQuery(sql).executeUpdate();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        
//        sess.setFlushMode(FlushMode.MANUAL);
//        sess.setCacheMode(CacheMode.IGNORE);
//        
//        List<StateBundleDesc> sbdl = sess.createQuery("from StateBundleDesc").list();
//        System.out.println("migrating " + sbdl.size() + " StateBundleDesc entities");
//        
//        sql = "UPDATE ccs_stateBundleDesc SET hashMD5=:md5 WHERE id=:id";
//        SQLQuery updateSBDQuery = sess.createSQLQuery(sql);
//        
//        for(StateBundleDesc sbd : sbdl) {
//            byte[] md5 = StateBundleDesc.computeMD5(sbd.getAgentDesc().getAgentName(), sbd.getComponentStates());
//            updateSBDQuery.setParameter("id", sbd.getId());
//            updateSBDQuery.setParameter("md5", md5);
//            updateSBDQuery.executeUpdate();
//        }
//        
//        tx.commit();
//        
//        tx = sess.beginTransaction();
//        List<AgentState> asl = sess.createQuery("from AgentState s").list();
//
//        System.out.println("migrating " + asl.size() + " AgentStates");
//        sql = "UPDATE ccs_agentState SET hashMD5=:md5 WHERE id=:id";
//        sq = sess.createSQLQuery(sql);
//        
//        for (AgentState s : asl) {
//            byte[] md5 = AgentState.computeMD5(s.getAgentDesc().getAgentName(), s.getComponentStates());
//            
//            sq.setParameter("id", s.getId());
//            sq.setParameter("md5", md5);
//            sq.executeUpdate();
//
//        }
//        tx.commit();
//        
//        System.out.println("migration done");
        
    }
    
}
