package org.lsst.ccs.localdb.statusdb.model;


import javax.persistence.Entity;
import javax.persistence.Lob;
import org.lsst.ccs.bus.messages.CommandMessage;

@Entity
public class CommandMessageData extends MessageData {

    private static final long serialVersionUID = 49230942038176402L;

    private String type, destination, correlId, content, origin;
    private long id, tstamp; 
    
    public CommandMessageData() {
        
    }
    
    public CommandMessageData(CommandMessage cmd) {
        this.type = cmd.getClass().getSimpleName();
        this.origin = cmd.getOriginAgentInfo().getName();
        this.destination = cmd.getDestination();
        this.correlId = cmd.getCorrelationId().toString();
        this.content = (String)cmd.getEncodedData();
        this.tstamp = cmd.getCCSTimeStamp().getUTCInstant().toEpochMilli();
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDestination() {
        return destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getCorrelId() {
        return correlId;
    }

    public void setCorrelId(String correlId) {
        this.correlId = correlId;
    }

    @Lob
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public long getTstamp() {
        return tstamp;
    }

    public void setTstamp(long tstamp) {
        this.tstamp = tstamp;
    }

    
    
}
