/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.common;

import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class LocaldbTestTemplate
extends CcsTestCaseTemplate {
    protected static SessionFactory sessionFactory;
    protected static final Properties p;

    @BeforeClass
    public static void initSessionFactory() throws Exception {
        p.setProperty("hibernate.generate_statistics", "true");
        p.setProperty("hibernate.dialect", "org.hibernate.dialect.HSQLDialect");
        p.setProperty("hibernate.connection.driver_class", "org.hsqldb.jdbcDriver");
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:mem:cache_size=200000");
        p.setProperty("hibernate.connection.username", "root");
        p.setProperty("hibernate.hbm2ddl.auto", "create");
        p.setProperty("hibernate.cache.use_query_cache", "true");
        p.setProperty("hibernate.cache.use_second_level_cache", "true");
        p.setProperty("hibernate.cache.region.factory_class", "org.hibernate.cache.ehcache.internal.EhcacheRegionFactory");
        p.setProperty("hibernate.javax.cache.uri", "cache/ehcache.xml");
        p.setProperty("hibernate.javax.cache.provider", "org.ehcache.jsr107.EhcacheCachingProvider");
        p.setProperty("hibernate.generate_statistics", "true");
        p.setProperty("hibernate.cache.use_reference_entries", "true");
    }

    @After
    public void printQueryStatistics() {
    }

    protected Session getSession() {
        Session s = sessionFactory.getCurrentSession();
        Transaction tx = s.getTransaction();
        if (!tx.isActive()) {
            tx.begin();
        }
        return s;
    }

    @AfterClass
    public static void closeSessionFactory() {
        StatusdbUtils.closeSessionFactory();
    }

    static {
        p = new Properties();
    }
}

