package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import java.util.Map;

/**
 * Defines a state channel for trending analysis.
 */
public class StateDataChannel extends Channel implements Serializable {

    private static final long serialVersionUID = 546412790910731443L;

    private String enumClass = "state";
        
    public StateDataChannel(String path, String enumClass) {
        super();
        this.path = path.split("/");
        if ( enumClass != null && !enumClass.isEmpty() ) {
            this.enumClass = enumClass;
        }
        addMetadata("type", this.enumClass);
    }

}
