package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.model.MetaDataData;

/**
 * Base class for a channel.
 * 
 * @author The LSST CCS Team
 */
@XmlRootElement(name = "datachannel")
public class Channel implements Serializable {
    
    @XmlElement(name = "pathelement")
    @XmlElementWrapper
    protected String[] path;
    
    @XmlElement(name = "metadata")
    protected MetaData[] mds;

    Map<String, String> metadata = new HashMap<>();
    private boolean metadataInitialized = false;
    
    
    Channel() {};

    final public String[] getPath() {
        return path;
    }

    final public String getPathAsString() {
        return DataPath.encodePath(getPath());
    }
    
//    @XmlElement(name = "metadata")
//    List<HashMapEntry4XML> getMetadataList() {
//        return HashMapEntry4XML.marshal(metadata);
//    }
    
    public Map<String, String> getMetadata() {
        if (!metadataInitialized) {
            metadataInitialized = true;
            if (mds != null) {
                for (MetaData md : mds) {
                    metadata.put(md.getName(), md.getValue());
                }
            }
        }
        return metadata;
    }

    
    static public class MetaData {

        @XmlAttribute
        private String name, value;

        public MetaData(MetaDataData d) {
            this.name = d.getName();
            this.value = d.getValue();
        }

        public MetaData() {
        }

        public MetaData(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return name;
        }

        public String getValue() {
            return value;
        }

    }
    
}
