package org.lsst.ccs.localdb.statusdb.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * Persistence for StatusStateChangeNotification messages.
 * @author LSST CCS Team
 */
@Entity
@Table(
        indexes = {@Index(columnList = "time"), @Index(columnList = "agentName"), @Index(columnList = "agentName, time")}        
)
public class StateChangeNotificationData extends StatusMessageData {
  
    private static final long serialVersionUID = 634282908394L;
    
    private AgentState oldState;
    
    public StateChangeNotificationData() {
        
    }

    @ManyToOne(fetch = FetchType.LAZY)
    public AgentState getOldState() {
        return oldState;
    }

    public void setOldState(AgentState data) {
        this.oldState = data;
    }
    
    @Transient
    public AgentState getNewState() {
        return getAgentState();
    }
}
