/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.util.Properties;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.stat.NaturalIdCacheStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.localdb.dao.LocaldbFacade;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StatTimeInterval;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class LocaldbFacadeTest
extends LocaldbTestTemplate {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.statusdb.model");

    @BeforeClass
    public static void setupClass() {
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
    }

    @Test
    public void testGetStatTimeInterval() {
        StatTimeInterval sti;
        int i;
        StatusdbUtils.closeSessionFactory();
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        Statistics stats = sessionFactory.getStatistics();
        NaturalIdCacheStatistics naturalCache = stats.getNaturalIdCacheStatistics(StatTimeInterval.class.getName() + "##NaturalId");
        SecondLevelCacheStatistics slCache = stats.getSecondLevelCacheStatistics(StatTimeInterval.class.getName());
        Session sess = sessionFactory.openSession();
        Transaction tx = sess.beginTransaction();
        Assert.assertEquals((String)"nothing in natural id cache", (long)0L, (long)naturalCache.getElementCountInMemory());
        long time = 0L;
        StatTimeInterval firstSti = null;
        for (i = 0; i < 1000; ++i) {
            sti = LocaldbFacade.getStatTimeInterval((long)300000L, (long)(time + (long)i), (Session)sess);
            if (firstSti == null) {
                firstSti = sti;
            }
            Assert.assertEquals((String)"stat time intervals should be equal", (Object)firstSti, (Object)sti);
        }
        tx.commit();
        sess.close();
        Assert.assertEquals((String)"there should be one element in natural id cache", (long)1L, (long)naturalCache.getElementCountInMemory());
        Assert.assertEquals((String)"there should be no hit in natural id cache", (long)0L, (long)naturalCache.getHitCount());
        Assert.assertEquals((String)"there should be one miss in natural id cache", (long)1L, (long)naturalCache.getMissCount());
        Assert.assertEquals((String)"there should be no hit in second level cache", (long)0L, (long)slCache.getHitCount());
        sess = sessionFactory.openSession();
        tx = sess.beginTransaction();
        firstSti = null;
        for (i = 0; i < 1000; ++i) {
            sti = LocaldbFacade.getStatTimeInterval((long)300000L, (long)(time + (long)i), (Session)sess);
            if (firstSti == null) {
                firstSti = sti;
            }
            Assert.assertEquals((String)"stat time intervals should be equal", (Object)firstSti, (Object)sti);
        }
        tx.commit();
        sess.close();
        Assert.assertEquals((String)"there should be one hit in natural id cache", (long)1L, (long)naturalCache.getHitCount());
        Assert.assertEquals((String)"there should be one miss in natural id cache", (long)1L, (long)naturalCache.getMissCount());
        Assert.assertEquals((String)"there should be one hit in second level cache", (long)1L, (long)slCache.getHitCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStatData() {
        Session sess = sessionFactory.openSession();
        try {
            Transaction tx = sess.beginTransaction();
            DataDesc dd = new DataDesc();
            dd.setDataPath(new DataPath("my-agent", "comp/mydata"));
            dd.setDataType("trending");
            sess.persist((Object)dd);
            StatDesc sd = new StatDesc();
            sd.setDataDesc(dd);
            sd.setTimeBinWidth(300000L);
            sess.persist((Object)sd);
            tx.commit();
            sess.close();
            sess = sessionFactory.openSession();
            sess.setFlushMode(FlushMode.MANUAL);
            tx = sess.beginTransaction();
            StatTimeInterval sti = LocaldbFacade.getStatTimeInterval((long)sd.getTimeBinWidth(), (long)System.currentTimeMillis(), (Session)sess);
            StatData stat = LocaldbFacade.getStatDataOrNull((StatDesc)sd, (StatTimeInterval)sti, (Session)sess);
            Assert.assertNull((Object)stat);
            RawData rd = new RawData();
            rd.setDataDesc(dd);
            rd.setDoubleData(Double.valueOf(Double.NaN));
            sess.persist((Object)rd);
            stat = new StatData(sd, rd, sti);
            sess.persist((Object)stat);
            StatData newStat = LocaldbFacade.getStatDataOrNull((StatDesc)sd, (StatTimeInterval)sti, (Session)sess);
            Assert.assertSame((Object)stat, (Object)newStat);
            tx.commit();
            sess.close();
        }
        finally {
            if (sess.isOpen()) {
                sess.close();
            }
        }
    }
}

