package org.lsst.ccs.localdb.statusdb.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * Persistence of a StatusClearedAlert.
 * @author LSST CCS Team
 */
@Entity
@Table(
        indexes = {@Index(columnList = "time")}
)
public class ClearedAlertData extends AlertData {
    private static final long serialVersionUID = -8004306509168597794L;

    public List<RaisedAlertData> clearedAlerts = new ArrayList<>();

    @OneToMany(mappedBy = "clearingAlert")
    public List<RaisedAlertData> getClearedAlerts() {
        return clearedAlerts;
    }

    public void setClearedAlerts(List<RaisedAlertData> clearedAlerts) {
        this.clearedAlerts = clearedAlerts;
    }
    
}
