package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

/**
 * Entity for a global configuration.
 * @author LSST CCS Team
 */
@Entity
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"descriptionId", "name", "version"})})
public class GlobalConfiguration implements Serializable {
    
    private static final long serialVersionUID = 5583430060244633755L;
    
    private long id;
    
    private String name;
    
    private int version;
    
    private BaseDescription baseDescription;
    
    private Map<String, Configuration> configurations;
    
    private boolean latest;
    
    protected GlobalConfiguration() {
        
    }
    
    public GlobalConfiguration(BaseDescription desc, String name, int version) {
        this.baseDescription = desc;
        this.name = name;
        this.version = version;
    }
    
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)    
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    // The global configuration name
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManyToOne(optional = false)
    public BaseDescription getDescription() {
        return baseDescription;
    }

    public void setDescription(BaseDescription description) {
        this.baseDescription = description;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isLatest() {
        return latest;
    }

    public void setLatest(boolean latest) {
        this.latest = latest;
    }

    @ManyToMany
    public Map<String, Configuration> getConfigurations() {
        return configurations;
    }

    public void setConfigurations(Map<String, Configuration> configurations) {
        this.configurations = configurations;
    }
    
}
