package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;

/**
 * Represents the static information of a configuration parameter.
 * @author bamade
 */

@Entity
@Immutable
@Table(
        uniqueConstraints = {
            @UniqueConstraint(columnNames = {"agentName", "componentName", "parameterName", "type", "category", "finalValue"}, name = "ccs_config_parm_u")
        }
)
@Cacheable
@org.hibernate.annotations.Cache(
        usage = org.hibernate.annotations.CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, 
        region = "org.lsst.ccs.localdb.configdb.model.ConfigurationParameter"
)
public class ConfigurationParameter implements Serializable, PathObject {

    private static final long serialVersionUID = 5660908759518934491L;
    
    private long id ;
    
    private String agentName;
    
    private ParameterPath parameterPath ;
    
    /**
     * type of parameter: class Name.
     * should have a valueOf(String) method
     */
    private String type ;
    
    /**
     * possible details.
     */
    protected String descriptionStr ;
    
    private String category;
    
    private String finalValue;

    ////////////////////////////// CONSTRUCTORS

    protected ConfigurationParameter() {

    }

    /**
     * @param agentName
     * @param path
     * @param typeName
     * @param description
     * @param category
     * @param finalValue
     */
    public ConfigurationParameter(String agentName, ParameterPath path, String typeName, String description, String category, String finalValue) {
        this.agentName = agentName;
        this.parameterPath = path;
        this.type = typeName;
        this.descriptionStr = description;
        this.category = category;
        this.finalValue = finalValue;
    }

    //////////////////////////// ACCESSORS/MUTATORS
    @Id
    @GeneratedValue(generator = "ID_SEQUENCE_GENERATOR")
    public long getId() {
        return id;
    }
    
    protected void setId(long id) {
        this.id = id ;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    
    public ParameterPath getParameterPath() {
        return parameterPath;
    }

    void setParameterPath(ParameterPath parameterPath) {
        this.parameterPath = parameterPath;
    }

    public String getDescriptionStr() {
        return descriptionStr;
    }

    /**
     * this data is not essential to the logic so it is modifiable anyway.
     * @param descriptionStr
     */
    void setDescriptionStr(String descriptionStr) {
        this.descriptionStr = descriptionStr ;
    }
    
    @Transient
    public boolean isFinal() {
        return finalValue != null;
    }
    
    public void setFinalValue(String finalValue) {
        this.finalValue = finalValue;
    }
    
    /** NULL if non final. */
    public String getFinalValue() {
        return finalValue;
    }
    
    public String getCategory(){
        return category;
    }
    
    void setCategory(String category){
        this.category = category;
    }

    @Override
    @Transient
    public ParameterPath getPath() {
        return parameterPath;
    }

    public String getType() {
        return type;
    }
    
    public void setType(String type) {
        this.type = type;
    }
    
    @Override
    public String toString() {
        return "{" + getId() + ": path=" + parameterPath.toString() + '}';
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.agentName);
        hash = 71 * hash + Objects.hashCode(this.parameterPath);
        hash = 71 * hash + Objects.hashCode(this.type);
        hash = 71 * hash + Objects.hashCode(this.category);
        hash = 71 * hash + Objects.hashCode(this.finalValue);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final ConfigurationParameter other = (ConfigurationParameter) obj;
        if (!Objects.equals(this.agentName, other.agentName)) {
            return false;
        }
        if (!Objects.equals(this.parameterPath, other.parameterPath)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.category, other.category)) {
            return false;
        }
        if (!Objects.equals(this.finalValue, other.finalValue)) {
            return false;
        }
        return true;
    }
    
    
    
}
