package org.lsst.ccs.localdb.statusdb.model;

import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;

/**
 * Persistence of alert events.
 * It stores the events corresponding to the receiving of StatusRaisedAlert and 
 * StatusClearedAlert messages.
 * 
 * @author The LSST CCS Team
 */

@MappedSuperclass
public class AlertData extends StatusMessageData {
    
    private static final long serialVersionUID = 789439024220L;
        
    protected AlertDesc alertDesc;

    /**
     * Public no-arg constructor.
     */
    public AlertData() {
        
    }

    @ManyToOne(optional = false)
    public AlertDesc getAlertDesc() {
        return alertDesc;
    }

    public void setAlertDesc(AlertDesc alertDesc) {
        this.alertDesc = alertDesc;
    }      
}
