/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.localdb.configdb.model.AParameterConfiguration;
import org.lsst.ccs.localdb.configdb.model.AParameterDescription;
import org.lsst.ccs.localdb.configdb.model.ASubsystemDescription;
import org.lsst.ccs.localdb.configdb.model.ConfigProfile;
import org.lsst.ccs.localdb.configdb.model.ImmutableStateException;
import org.lsst.ccs.localdb.configdb.model.PackCst;
import org.lsst.ccs.localdb.configdb.model.ParameterConfiguration;
import org.lsst.ccs.localdb.configdb.model.ParameterDescription;
import org.lsst.ccs.utilities.logging.Logger;

@Table(uniqueConstraints={@UniqueConstraint(columnNames={"name", "tag", "subsystemName"})})
@Entity
@Immutable
class AConfigProfile
extends ConfigProfile
implements Cloneable {
    private static final long serialVersionUID = -6199141309488812631L;
    @Id
    @GeneratedValue
    private long id;
    @ManyToOne(fetch=FetchType.EAGER)
    private ASubsystemDescription subsystemDesc;
    private long subsystemId;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private Set<AParameterConfiguration> parameterConfigurations = new HashSet<AParameterConfiguration>();

    AConfigProfile() {
    }

    AConfigProfile(ASubsystemDescription subsystemDesc, String categoryName, String configName) {
        super(subsystemDesc.getSubsystemName(), subsystemDesc.getTag(), categoryName, configName);
        this.subsystemDesc = subsystemDesc;
        this.subsystemId = subsystemDesc.getId();
        long endDate = subsystemDesc.getEndTimestamp();
        if (endDate != PackCst.STILL_VALID) {
            throw new IllegalArgumentException("using deprecated subsystem");
        }
    }

    AConfigProfile(AConfigProfile anotherConfig, String newName) {
        this(anotherConfig.getSubsystemDesc(), anotherConfig.getCategoryName(), newName == null ? anotherConfig.getConfigName() : newName);
        for (AParameterConfiguration parmConfig : anotherConfig.getParameterConfigurations()) {
            AParameterConfiguration copyParm = new AParameterConfiguration(parmConfig);
            this.addParameterConfigurations(copyParm);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    protected void setId(long id) {
        this.id = id;
    }

    @Override
    public ASubsystemDescription getSubsystemDescription() {
        return this.subsystemDesc;
    }

    @Override
    public Set<? extends ParameterConfiguration> getModifiedParameters() {
        return this.getParameterConfigurations();
    }

    ASubsystemDescription getSubsystemDesc() {
        return this.subsystemDesc;
    }

    void setSubsystemDesc(ASubsystemDescription subsystemDesc) {
        this.subsystemDesc = subsystemDesc;
    }

    public Set<AParameterConfiguration> getParameterConfigurations() {
        return Collections.unmodifiableSet(this.parameterConfigurations);
    }

    void setParameterConfigurations(Set<AParameterConfiguration> parameterConfigurations) {
        this.parameterConfigurations = parameterConfigurations;
    }

    public AConfigProfile clone() throws CloneNotSupportedException {
        AConfigProfile res = null;
        res = (AConfigProfile)super.clone();
        HashSet<AParameterConfiguration> newSet = new HashSet<AParameterConfiguration>();
        for (AParameterConfiguration parmConfig : this.parameterConfigurations) {
            newSet.add(parmConfig.clone());
        }
        res.setParameterConfigurations(newSet);
        return res;
    }

    public long getSubsystemId() {
        return this.subsystemId;
    }

    void setSubsystemId(long subsystemId) {
        this.subsystemId = subsystemId;
    }

    @Override
    public void addParameterConfiguration(String parameterName, String value) {
        ParameterDescription description = this.subsystemDesc.fetch(parameterName);
        if (description != null) {
            this.addParameterConfigurations(new AParameterConfiguration((AParameterDescription)description, value));
        } else {
            Logger.getLogger((String)"org.lsst.ccs.config").warn((Object)("incoherent name for parameter : " + parameterName + " : ignored"));
        }
    }

    public void addParameterConfigurations(AParameterConfiguration ... parameterConfigurations) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("no modification of registered data");
        }
        for (AParameterConfiguration parameterConfiguration : parameterConfigurations) {
            AParameterDescription description = parameterConfiguration.getParameterDescription();
            if (description.getCategory().equals(this.getCategoryName())) {
                this.parameterConfigurations.add(parameterConfiguration);
                continue;
            }
            Logger.getLogger((String)"org.lsst.ccs.config").warn((Object)("The property " + description.getParameterName() + " does not belong to the category specified by the property file name : " + this.getCategoryName()));
        }
    }

    @Override
    public void addParameterConfigurations(ParameterConfiguration ... parameterConfigurations) {
        this.addParameterConfigurations(this.buildSafeArray(parameterConfigurations));
    }

    private AParameterConfiguration[] buildSafeArray(ParameterConfiguration ... parameterConfigurations) {
        AParameterConfiguration[] parms = new AParameterConfiguration[parameterConfigurations.length];
        for (int ix = 0; ix < parameterConfigurations.length; ++ix) {
            ParameterConfiguration conf = parameterConfigurations[ix];
            if (!(conf instanceof AParameterConfiguration)) {
                throw new IllegalArgumentException("deprecated parameter Configuration");
            }
            parms[ix] = (AParameterConfiguration)conf;
        }
        return parms;
    }

    @Override
    public void removeParameterConfigurations(ParameterConfiguration ... parameterConfigurations) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("Parameter Configuration list");
        }
        for (ParameterConfiguration parameterConfiguration : parameterConfigurations) {
            this.parameterConfigurations.remove(parameterConfiguration);
        }
    }
}

