package org.lsst.ccs.localdb.configdb.model;

import javax.persistence.*;

/**
 * Actual parameter configuration.
 * TODO: when setting up the value this data will be checked for constraints and type against
 * its ParameterDescription.
 * <P>
 *  All values are represented as String.
 *  The type in ParameterDescription should have a static <TT>valueOf(String val)</TT>
 *  method. This is the case for the standard "wrapper" classes.
 *  Other non-standard classes may be provided with the same feature (including classes that
 *  may represent "structures" such as arrays, lists or maps).
 *  If the value is generated then it will be checked with the constraints type (to be specified).
 *
 * @author bamade
 */
// Date: 11/04/12

@Entity
class AParameterConfiguration extends ParameterConfiguration implements Cloneable {
        
    private static final long serialVersionUID = 8134633715625475333L;
    
    @Id
    @GeneratedValue
    private long id;
    
    @ManyToOne (fetch=FetchType.EAGER)
    private AParameterDescription parameterDescription ;

    private boolean copy ;

    AParameterConfiguration() {

    }

    /**
     * create an empty parameter configuration whose value is to be modified
     * @param parameterDescription
     */
    AParameterConfiguration(AParameterDescription parameterDescription) {
        super(parameterDescription.getParameterBase().getDefaultValue()) ;
        this.parameterDescription = parameterDescription;
    }

    /**
     *
     * @param parameterDescription
     * @param value
     * @throws IllegalArgumentException if value is not coherent with type and constraints
     */
    AParameterConfiguration(AParameterDescription parameterDescription, String value) {
        super();
        this.parameterDescription = parameterDescription;
        modifyValue(value);
    }
    
    /**
     * Copy constructor of a parameter configuration
     * @param other
     */
    AParameterConfiguration(AParameterConfiguration other){
        this(other.getParameterDescription(),other.getValue());
    }

    @Override
    public long getId() {
        return id;
    }

    @Override
    protected void setId(long id) {
        this.id = id ;
    }

    @Override
    public ParameterDescription getDescription() {
        return parameterDescription;
    }

    AParameterDescription getParameterDescription() {
        return parameterDescription;
    }

     void setParameterDescription(AParameterDescription parameterDescription) {
        this.parameterDescription = parameterDescription;
    }

    public boolean isCopy() {
        return copy;
    }

     void setCopy(boolean copy) {
        this.copy = copy;
    }

    public AParameterConfiguration clone() throws CloneNotSupportedException {
        AParameterConfiguration res = new AParameterConfiguration(this);
        res.setCopy(true);
        return res ;
    }
}
