package org.lsst.ccs.localdb.statusdb.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicUpdate = true, dynamicInsert = true)
@Table(name = "statdesc")
public class StatDesc {

    private long id;
    private DataDesc rawDescr;
    private long timeBinWidth;
    private long preservationDelay;

    /**
     * @return the id
     */
    @Id()
    @GeneratedValue(strategy = GenerationType.AUTO)
    public long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * @return the rawDescr
     */
    @ManyToOne
    public DataDesc getRawDescr() {
        return rawDescr;
    }

    /**
     * @param rawDescr the rawDescr to set
     */
    public void setRawDescr(DataDesc rawDescr) {
        this.rawDescr = rawDescr;
    }

    /**
     * @return the timeBinWidth
     */
    public long getTimeBinWidth() {
        return timeBinWidth;
    }

    /**
     * @param timeBinWidth the timeBinWidth to set
     */
    public void setTimeBinWidth(long timeBinWidth) {
        this.timeBinWidth = timeBinWidth;
    }

    /**
     * @return the preservationDelay
     */
    @Column(columnDefinition = "int default 0")
    public long getPreservationDelay() {
        return preservationDelay;
    }

    /**
     * @param preservationDelay the preservationDelay to set
     */
    public void setPreservationDelay(long preservationDelay) {
        this.preservationDelay = preservationDelay;
    }
}
