package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.ManyToOne;

@Entity
@org.hibernate.annotations.Entity(dynamicUpdate = true, dynamicInsert = true)
@Table(name = "datametadata")
public class DataMetaData implements Serializable {

    private DataDesc rawDescr;
    private long tstart, tstop = -1;
    private String name, value;
    private long id;

    /**
     * @return the id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the value
     */
    public String getValue() {
        return value;
    }

    /**
     * @param value
     *            the value to set
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * @return the rawDescr
     */
    @ManyToOne
    public DataDesc getRawDescr() {
        return rawDescr;
    }

    /**
     * @param rawDescr the rawDescr to set
     */
    public void setRawDescr(DataDesc rawDescr) {
        this.rawDescr = rawDescr;
    }

    /**
     * @return the tstart
     */
    @Column(name = "tstartmillis")
    public long getTstart() {
        return tstart;
    }

    /**
     * @param tstart the tstart to set
     */
    public void setTstart(long tstart) {
        this.tstart = tstart;
    }

    /**
     * @return the tstop
     */
    @Column(name = "tstopmillis")
    public long getTstop() {
        return tstop;
    }

    /**
     * @param tstop the tstop to set
     */
    public void setTstop(long tstop) {
        this.tstop = tstop;
    }
}
