package org.lsst.ccs.localdb.statusdb;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.apache.log4j.Logger;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.localdb.Trending;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataMetaData;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;

public class StatusPersister implements StatusListener {

    /*
     * public static AnnotationConfiguration ac = new AnnotationConfiguration();
     * public static Configuration cfg = ac.configure("hibernate-tm.cfg.xml");
     * public static SessionFactory fac = cfg.buildSessionFactory();
     */
    public static AnnotationConfiguration ac;
    public static Configuration cfg;
    public static SessionFactory fac;

    public static synchronized void init() {
        if (ac == null) {
            ac = new AnnotationConfiguration();
        }
        if (cfg == null) {
            cfg = ac.configure("hibernate-tm.cfg.xml");
        }
        if (fac == null) {
            fac = cfg.buildSessionFactory();
        }
    }
    static Logger log = Logger.getLogger("lsst.ccs.db");
    // TODO for more efficiency, accumulate messages in a buffer and have a
    // different thread persists
    // blocks of data periodically.
    // list of data to be persisted
    Map<String, DataDesc> map = new ConcurrentHashMap<String, DataDesc>();
    protected DataWriter writer = new DataWriter();

    // todo : force a re-read of the database
    // or re-read the database periodically?
    @SuppressWarnings("unchecked")
    public StatusPersister() {
        init();
        log.info("Starting StatusPersister");
        Session sess = fac.openSession();
        List<DataDesc> l = sess.createQuery("from DataDesc").list();
        for (DataDesc dd : l) {
            String key = dd.getSrcSubsystem() + "/" + dd.getSrcName();
            map.put(key, dd);
            log.info("storing " + key);
        }
        sess.close();

        // new Thread(writer).start(); // TODO use executors? Scheduled?
        // Multithread?
        // TODO stop cleanly the writer thread?
    }

    public void onStatus(BusMessage s) {
        if (s instanceof TrendingStatus) {

            // TODO accept JavaBeans as aggregate of several values. Create a top
            // class for those.

            TrendingStatus pv = (TrendingStatus) s;

            persistTrendingStatus(pv);
        } else if (s instanceof MetadataStatus) {
            persistMetadataStatus((MetadataStatus) s);
        }
    }

    // WORK IN PROGRESS START
    // this saves an individual piece of data, called for composite objects n
    // times
    public void persist(long tStamp, String name, Object d) {
        DataDesc dd = getDataDescription(name);
        if (dd == null) {
            return;
        }
        RawData data = new RawData();
        data.setTstamp(tStamp);// new Timestamp(pv.getTimeStamp());
        data.setDescr(dd);
        if (d instanceof Double) {
            data.setDoubleData((Double) d);
        } else if (d instanceof Float) {
            data.setDoubleData((Double) (double) (Float) d);
        } else {
            data.setStringData(d.toString());
        }

        q.add(data);
    }

    public void persist(TrendingStatus pv) {
        ValueNotification dt = (ValueNotification) pv.getValue();

        // TODO handle simple or composite data object

        String key = pv.getOrigin() + "/" + dt.getName();

        log.debug("got update (persist) " + key);
        DataDesc dd = getDataDescription(key);

        if (dd == null) {
            return;
        }

        RawData data = new RawData();
        data.setTstamp(dt.gettStamp());// new Timestamp(pv.getTimeStamp());
        data.setDescr(dd);
        if (dt.getData() instanceof Double) {
            data.setDoubleData((Double) dt.getData());
        } else if (dt.getData() instanceof Float) {
            data.setDoubleData((Double) (double) (Float) dt.getData());
        } else {
            data.setStringData(pv.getValue().toString());
        }

        q.add(data);
    }
    // TODO handle overflows, use blocking queue?
    protected ConcurrentLinkedQueue<RawData> q = new ConcurrentLinkedQueue<RawData>();

    public class DataWriter implements Runnable {

        public void run() {
            ArrayList<RawData> workingList = new ArrayList<RawData>(1000);
            long sleepTime = 1000L;
            long lastSleep = -1L; // last time we slept after doing real work

            // get at most 1000 objets from the queue
            int i = 0;
            while (i < 1000) {
                RawData d = q.poll();
                if (d == null) {
                    break;
                }
                workingList.add(d);
                i++;
            }

            // persist them

            // see if queue is empty, time since last run, and sleep accordingly

        }
    }

    // WORK IN PROGRESS END
    public void persistTrendingStatus(TrendingStatus pv) {
        persistData(pv.getOrigin(), pv.getTimeStamp(), pv.getValue());
    }

    // Trending data can be published in three ways
    // - a single ValueNotification object, i.e. name, Object, timestamp
    // - a list of ValueNotification objects for publishing a whole bunch of
    // data with different timestamps (like in the case of the shutter movement)
    // - to publish a lot of values with the same timestamp a structure is
    // published. All the member variables annotated with @Trending will be
    // added to the
    // trending database with the name of the variable.
    public void persistData(String origin, long ts, Object p) {
        if (p instanceof ValueNotification[]) {
            ValueNotification[] vv = (ValueNotification[]) p;
            for (ValueNotification v : vv) {
                persistData(origin, v.gettStamp(), v);
            }
        } else if (p instanceof List<?> && !((List<?>) p).isEmpty()
                && ((List<?>) p).get(0) instanceof ValueNotification) {
            @SuppressWarnings("unchecked")
            List<ValueNotification> vv = (List<ValueNotification>) p;
            for (ValueNotification v : vv) {
                persistData(origin, v.gettStamp(), v);
            }
        } else if (p instanceof ValueNotification) {
            ValueNotification dt = (ValueNotification) p;
            Object data = dt.getData();
            ts = dt.gettStamp();
            if (data instanceof Number || data instanceof String) {
                String key = origin + "/" + dt.getName();
                persistImmediateScalar(ts, key, data);
            } else {
                Class<? extends Object> dataClass = data.getClass();
                log.debug("will try to persist class " + dataClass);
                boolean saveAll = dataClass.isAnnotationPresent(Trending.class);
                Field[] fields = dataClass.getDeclaredFields();
                for (Field f : fields) {
                    if (saveAll || f.isAnnotationPresent(Trending.class)) {
                        try {
                            log.debug("persisting field " + f.getName());
                            Object d = f.get(data);
                            String key = origin + "/" + dt.getName() + "/"
                                    + f.getName();
                            persistImmediateScalar(ts, key, d);
                        } catch (IllegalArgumentException ex) {
                            log.error("pb reading field", ex);
                        } catch (IllegalAccessException ex) {
                            log.error("pb reading field", ex);
                        }
                    }

                }
            }
        } else {
            log.info("can't persist " + p + " class " + p.getClass());
            // this is not worth an exception. Or is it?
            // or should we try to persist stuff not encapsulated in
            // ValueNotification?
        }
    }

    public void persistMetadataStatus(MetadataStatus mst) {
        String dataName = mst.getOrigin() + "/" + mst.getDataName();

        DataDesc dd = getDataDescription(dataName);

        Session sess = fac.openSession();
        Transaction tx = sess.beginTransaction();
        sess.lock(dd, LockMode.NONE);

        DataMetaData metadata = new DataMetaData();
        metadata.setName(mst.getMetadataName());
        metadata.setRawDescr(dd);
        metadata.setValue(mst.getMetadataValue());
        metadata.setTstart(mst.getTimeStamp());

        //First update the tstop of a previously existing record for this metadata
        Query q = sess.createQuery("from DataMetaData md where rawDescr_id = :id and name = :n and tstopmillis <= 0");
        q.setParameter("id", dd.getId());
        q.setParameter("n", metadata.getName());
        DataMetaData oldMetaData = (DataMetaData) q.uniqueResult();
        if (oldMetaData != null) {
            oldMetaData.setTstop(metadata.getTstart());
            sess.update(oldMetaData);
        }
        //Now commit the new value of the metadata
        sess.persist(metadata);

        tx.commit();
        sess.close();
    }

    public void persistImmediateScalar(long tStamp, String name, Object d) {
        DataDesc dd = getDataDescription(name);

        if (dd == null) {
            return;
        }

        log.debug("got update " + name);

        RawData data = new RawData();
        data.setTstamp(tStamp);
        data.setDescr(dd);
        if (d instanceof Double) {
            data.setDoubleData((Double) d);
        } else if (d instanceof Float) {
            data.setDoubleData((Double) (double) (Float) d);
        } else if (d instanceof Integer) {
            data.setDoubleData((Double) (double) (Integer) d);
        } else if (d instanceof Short) {
            data.setDoubleData((Double) (double) (Short) d);
        } else {
            data.setStringData(d.toString());
        }

        Session sess = fac.openSession();
        Transaction tx = sess.beginTransaction();
        sess.lock(dd, LockMode.NONE);
        sess.persist(data);

        List<StatDesc> stats = dd.getDerived();
        // TODO use named queries
        Query q = sess.createQuery("from StatData s where s.descr = :d order by s.tstampFirst desc");
        q.setLockMode("s", LockMode.UPGRADE);
        for (StatDesc stat : stats) {
            q.setEntity("d", stat);
            q.setMaxResults(1);
            StatData sd = (StatData) q.uniqueResult();
            if (sd == null) {
                sd = new StatData(stat, data);
                sess.persist(sd);
            } else if (data.getTstamp() > sd.getTstampFirst()
                    + stat.getTimeBinWidth()) {
                sd = new StatData(stat, data);
                sess.persist(sd);
            } else {
                sd.accumulate(data);
            }
        }

        tx.commit();
        sess.close();
    }

    private DataDesc getDataDescription(String key) {

        DataDesc dd = map.get(key);
        log.debug("Looking for data description in map " + map + " " + key);
        
        // TODO we should not do that in production.

        if (dd == null) {
            log.debug("Adding default Data Description for " + key);
            dd = new DataDesc();
            dd.setDataType("a");
            dd.setName(key);
            int ind = key.indexOf("/");
            dd.setSrcName(key.substring(ind + 1));
            dd.setSrcSubsystem(key.substring(0, ind));

            Session sess = fac.openSession();
            Transaction tx = sess.beginTransaction();
            try {
                sess.persist(dd);
                tx.commit();
            } finally {
                sess.close();
            }
            map.put(key, dd);
        }

        return dd;
    }
}
