/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.status;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.subsystem.shutter.common.RTD;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.status.PtpDeviceState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class ShutterStatus
implements Serializable {
    private static final long serialVersionUID = 7L;
    @DataAttributes(description="Type of motion profile. 0 = S-curve.", units="unitless")
    private final int motionProfile;
    @DataAttributes(description="Hall switch positions calibrated? 0 = no, 1 = yes.", units="unitless")
    private final int isCalibrated;
    @DataAttributes(description="The state of the shutter controller's state machine.", units="unitless")
    private final int smState;
    private final Map<ShutterSide, ShutterAxisStatus> axstatus;
    @DataAttributes(description="0 for shutter safety checks disable, 1 for enabled.", units="unitless")
    private final int isSafetyOn;
    @DataAttributes(description="RTD temperatures.", units="Celsius")
    private final Map<RTD, Double> temperature;
    @DataAttributes(description="RTD temperature in safe range? 0 = no, 1 = yes.", units="unitless")
    private final Map<RTD, Integer> tempIsSafe;
    @DataAttributes(description="Is brake power on? 0 = no, 1 = yes.", units="unitless")
    private final int brakePowerIsOn;
    @DataAttributes(description="The time at which this message was created or last updated. The output of CCSTimeStamp.getTAIDouble().", units="s")
    private final double creationTime;
    @DataAttributes(description="The state of the PTP module.", units="unitless")
    private final int ptpState;
    @DataAttributes(description="The current number of leap seconds from the PTP module.", units="count")
    private final int leapSeconds;
    @DataAttributes(description="Is the PTP leap-second count valid? 0 = no, 1 = yes.", units="unitless")
    private final int leapIsValid;

    public ShutterStatus(int motionProfile, boolean isCalibrated, int smState, Map<ShutterSide, ShutterAxisStatus> axes, boolean isSafetyOn, Map<RTD, Double> temperature, Map<RTD, Boolean> tempIsSafe, boolean brakePowerIsOn, CCSTimeStamp creationTime, PtpDeviceState ptpState, int leapSeconds, boolean leapIsValid) {
        this.motionProfile = motionProfile;
        this.isCalibrated = isCalibrated ? 1 : 0;
        this.smState = smState;
        this.axstatus = new EnumMap<ShutterSide, ShutterAxisStatus>(axes);
        int n = this.isSafetyOn = isSafetyOn ? 1 : 0;
        if (temperature == null || temperature.size() != 3) {
            throw new IllegalArgumentException("Temperature map is null or has size != 3");
        }
        if (tempIsSafe == null || tempIsSafe.size() != 3) {
            throw new IllegalArgumentException("Temp-is-safe map is null or has size != 3");
        }
        this.temperature = new TreeMap<RTD, Double>(temperature);
        this.tempIsSafe = new TreeMap<RTD, Integer>();
        for (RTD rtd : RTD.values()) {
            this.tempIsSafe.put(rtd, tempIsSafe.get((Object)rtd) != false ? 1 : 0);
        }
        this.brakePowerIsOn = brakePowerIsOn ? 1 : 0;
        this.creationTime = creationTime.getTAIDouble();
        this.ptpState = PtpDeviceState.toStateNumber(ptpState);
        this.leapSeconds = leapSeconds;
        this.leapIsValid = leapIsValid ? 1 : 0;
    }

    public int getMotionProfile() {
        return this.motionProfile;
    }

    public boolean isCalibrated() {
        return this.isCalibrated == 1;
    }

    public int getSmState() {
        return this.smState;
    }

    public ShutterAxisStatus getAxisStatus(ShutterSide side) {
        return this.axstatus.get((Object)side);
    }

    public boolean isSafetyOn() {
        return this.isSafetyOn == 1;
    }

    public Map<RTD, Double> getTemperature() {
        return new TreeMap<RTD, Double>(this.temperature);
    }

    public Map<RTD, Boolean> getTempIsSafe() {
        TreeMap<RTD, Boolean> result = new TreeMap<RTD, Boolean>();
        for (RTD rtd : RTD.values()) {
            result.put(rtd, this.tempIsSafe.get((Object)rtd) == 1);
        }
        return result;
    }

    public boolean brakePowerIsOn() {
        return this.brakePowerIsOn == 1;
    }

    public double getCreationTime() {
        return this.creationTime;
    }

    public PtpDeviceState getPtpState() {
        return PtpDeviceState.fromStateNumber(this.ptpState);
    }

    public int getPtpStateAsInt() {
        return this.ptpState;
    }

    public int getLeapSeconds() {
        return this.leapSeconds;
    }

    public boolean isLeapValid() {
        return this.leapIsValid != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ShutterStatus{motionProfile=").append(this.motionProfile);
        sb.append(", isCalibrated=").append(this.isCalibrated);
        sb.append(", smState=").append(this.smState);
        sb.append(", axstatus=").append(this.axstatus);
        sb.append(", isSafetyOn=").append(this.isSafetyOn);
        sb.append(", temperature=").append(this.temperature);
        sb.append(", tempIsSafe=").append(this.tempIsSafe);
        sb.append(", brakePowerIsOn=").append(this.brakePowerIsOn);
        sb.append('}');
        return sb.toString();
    }

    public static final class ShutterAxisStatus
    implements Serializable {
        private static final long serialVersionUID = 3L;
        @DataAttributes(description="The actual blade set axis encoder reading.", units="mm")
        private final double actPos;
        @DataAttributes(description="The actual blade set velocity from the encoder.", units="mm/s")
        private final double actVel;
        @DataAttributes(description="The requested blade set acceleration.", units="mm/s2")
        private final double setAcc;
        @DataAttributes(description="Is the motor enabled? 0 = no, 1 = yes.", units="unitless")
        private final int enabled;
        @DataAttributes(description="Is the motor brake engaged? 0 = no, 1 = yes.", units="unitless")
        private final int brakeEngaged;
        @DataAttributes(description="Is the blade set at its low motion limit? 0 = no, 1 = yes. ", units="unitless")
        private final int lowLimit;
        @DataAttributes(description="Is the blade set at its high motion limit? 0 = no, 1 = yes. ", units="unitless")
        private final int highLimit;
        @DataAttributes(description="Has the axis been calibrated? 0 = no, 1 = yes.", units="unitless")
        private final int isHomed;
        @DataAttributes(description="Beckhoff error code for last operation. 0 = OK.", units="unitless")
        private final int errorID;
        @DataAttributes(description="Temperature of the motor controller chip. ", units="Celsius")
        private final double ctrlTemp;
        @DataAttributes(description="Is the temperature of the motor controller in the safe range? 0 = no, 1 = yes.", units="unitless")
        private final int hasSafeTemp;

        public ShutterAxisStatus(double actPos, double actVel, double setAcc, boolean enabled, boolean brakeEngaged, boolean lowLimit, boolean highLimit, boolean isHomed, int errorID, double ctrlTemp, boolean hasSafeTemp) {
            this.actPos = actPos;
            this.actVel = actVel;
            this.setAcc = setAcc;
            this.enabled = enabled ? 1 : 0;
            this.brakeEngaged = brakeEngaged ? 1 : 0;
            this.lowLimit = lowLimit ? 1 : 0;
            this.highLimit = highLimit ? 1 : 0;
            this.isHomed = isHomed ? 1 : 0;
            this.errorID = errorID;
            this.ctrlTemp = ctrlTemp;
            this.hasSafeTemp = hasSafeTemp ? 1 : 0;
        }

        public String toString() {
            return "AxisStatus{actPos=" + this.actPos + ", actVel=" + this.actVel + ", setAcc=" + this.setAcc + ", enabled=" + this.enabled + ", brakeEngaged=" + this.brakeEngaged + ", lowLimit=" + this.lowLimit + ", highLimit=" + this.highLimit + ", isHomed=" + this.isHomed + ", errorID=" + this.errorID + ", ctrlTemp=" + this.ctrlTemp + ", hasSafeTemp=" + this.hasSafeTemp + '}';
        }

        public double getActPos() {
            return this.actPos;
        }

        public double getActVel() {
            return this.actVel;
        }

        public double getSetAcc() {
            return this.setAcc;
        }

        public boolean isEnabled() {
            return this.enabled == 1;
        }

        public boolean isBrakeEngaged() {
            return this.brakeEngaged == 1;
        }

        public boolean atLowLimit() {
            return this.lowLimit == 1;
        }

        public boolean atHighLimit() {
            return this.highLimit == 1;
        }

        public boolean isHomed() {
            return this.isHomed == 1;
        }

        public int getErrorID() {
            return this.errorID;
        }

        public double getCtrlTemp() {
            return this.ctrlTemp;
        }

        public boolean hasSafeTemp() {
            return this.hasSafeTemp == 1;
        }
    }
}

