/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class ChillerSwitches {
    public static final int SW_ENABLE_CHILLER = 0;
    public static final int NUM_SWITCHES = 1;
    private static final Map<String, Integer> NAME_MAP = new LinkedHashMap<String, Integer>();
    private static final Map<Integer, String> ID_MAP;

    public static List<String> getNames() {
        return new ArrayList<String>(NAME_MAP.keySet());
    }

    public static String getName(int id) {
        return ID_MAP.get(id);
    }

    public static int getId(String name) throws RefrigException {
        Integer id = NAME_MAP.get(name);
        if (id == null) {
            throw new RefrigException("Invalid switch name: " + name);
        }
        return id;
    }

    static {
        NAME_MAP.put("Block", 0);
        ID_MAP = new LinkedHashMap<Integer, String>();
        for (Map.Entry<String, Integer> e : NAME_MAP.entrySet()) {
            ID_MAP.put((int)e.getValue(), e.getKey());
        }
    }
}

