/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.actions.RebPowerAction;
import org.lsst.ccs.subsystem.power.CornerRaftRebPowerSupplyNode;
import org.lsst.ccs.subsystem.power.PowerSupplyConfiguration;
import org.lsst.ccs.subsystem.power.RebPowerAlarm;
import org.lsst.ccs.subsystem.power.RebPsDevice;
import org.lsst.ccs.subsystem.power.alerts.RebPowerAlertType;
import org.lsst.ccs.subsystem.power.constants.RebPsEnum;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.states.RebDPhiState;
import org.lsst.ccs.subsystem.power.states.RebHvBiasState;
import org.lsst.ccs.subsystem.power.states.RebPowerState;

public class RebPowerSupplyNode
implements HasLifecycle {
    protected final PowerSupplyConfiguration powerSupplyConfiguration;
    protected final int channel;
    protected static final Logger LOG = Logger.getLogger(RebPowerSupplyNode.class.getName());
    @LookupName
    protected String rebName;
    @LookupPath
    protected String rebPath;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Map<String, RebPsDevice> psDevices = new HashMap<String, RebPsDevice>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="Power")
    private Channel powerChannel;
    @ConfigurationParameter(range="0..3200", units="V", description="REB bias voltage")
    protected volatile int hvBias;
    protected RebPsDevice powerSupplyDevice;
    private volatile boolean disableRebPowerOn = false;
    private volatile boolean disableRebHvBiasOn = false;
    private final Object powerOnOffLock = new Object();
    private final Object hvBiasOnOffLock = new Object();
    private final Map<RebPowerAction.Type, List<String>> outstandingAlerts = new ConcurrentHashMap<RebPowerAction.Type, List<String>>();

    public RebPowerSupplyNode(PowerSupplyConfiguration powerSupplyConfiguration, int channel) {
        this.channel = channel;
        this.powerSupplyConfiguration = powerSupplyConfiguration;
    }

    public void build() {
        String psName = this.powerSupplyConfiguration.getName();
        for (Map.Entry<String, RebPsDevice> e : this.psDevices.entrySet()) {
            if (!e.getKey().endsWith(psName)) continue;
            if (this.powerSupplyDevice != null) {
                throw new RuntimeException("Found more than one power supply that matches name " + this.powerSupplyConfiguration.getName());
            }
            this.powerSupplyDevice = e.getValue();
        }
        if (this.powerSupplyDevice == null) {
            throw new RuntimeException("Could not find power supply device " + this.powerSupplyConfiguration.getName() + " corresponding to this reb " + this.rebName);
        }
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(RebPowerAlarm.getRebPowerAlert(RebPowerAlertType.EMERGENCY_ACTION_FAILED, this.rebPath), alwaysClear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigurationParameterChanger(propertyName="hvBias")
    public void setHVBias(int hvBias) {
        this.hvBias = hvBias;
        Object object = this.agentStateService.getStateLock();
        synchronized (object) {
            if (this.agentStateService.isComponentInState(this.rebPath, (Enum)RebPowerState.ON)) {
                this.writeHvBiasConfigurationValueToDac();
            }
        }
    }

    private void writeHvBiasConfigurationValueToDac() {
        try {
            this.powerSupplyDevice.setBiasDac(this.channel, this.hvBias);
            LOG.log(Level.INFO, "{0}: set hvBias DAC value of {1}", new Object[]{this.rebPath, this.hvBias});
        }
        catch (PowerException ex) {
            LOG.log(Level.WARNING, "Could not set the HVBias DAC value", ex);
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Turns on the power to this Reb", autoAck=false)
    public void powerRebOn() throws PowerException {
        Object object = this.powerOnOffLock;
        synchronized (object) {
            this.agent.helper().precondition(!this.disableRebPowerOn, this.rebPath + ": powering on has been disabled due to outstanding alerts: " + this.outstandingAlerts.get(RebPowerAction.Type.TURN_REB_OFF), new Supplier[0]).precondition(this.agentStateService.isComponentInState(this.rebPath, (Enum)RebHvBiasState.OFF), "The Reb hvBias switch must be open.", new Supplier[0]).precondition(this instanceof CornerRaftRebPowerSupplyNode ? this.agentStateService.isComponentInState(this.rebPath, (Enum)RebDPhiState.OFF) : true, "The Reb dphi switch must be open.", new Supplier[0]).enterFaultOnException(true).action(() -> {
                this.powerSupplyDevice.sequencePower(this.channel, true);
                this.writeHvBiasConfigurationValueToDac();
                if (this instanceof CornerRaftRebPowerSupplyNode) {
                    ((CornerRaftRebPowerSupplyNode)this).writeDphiConfigurationValueToDac();
                }
            });
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turns off the power to this Reb")
    public void powerRebOff() throws PowerException {
        this.powerRebOff(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void powerRebOff(boolean disable) throws PowerException {
        Object object = this.powerOnOffLock;
        synchronized (object) {
            this.disableRebPowerOn = disable;
            this.powerSupplyDevice.sequencePower(this.channel, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Turns on the HV bias to the configuration value", autoAck=false)
    public void hvBiasOn() throws PowerException {
        Object object = this.hvBiasOnOffLock;
        synchronized (object) {
            this.agent.helper().precondition(!this.disableRebHvBiasOn, this.rebPath + ": HvBias on has been disabled due to outstanding alerts: " + this.outstandingAlerts.get(RebPowerAction.Type.TURN_REB_HVBIAS_OFF), new Supplier[0]).precondition(this.agentStateService.isComponentInState(this.rebPath, (Enum)RebPowerState.ON), "The Reb main power must be ON.", new Supplier[0]).enterFaultOnException(true).action(() -> this.powerSupplyDevice.setPowerOn(this.channel, RebPsEnum.HVBIAS.getNumber(), true));
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turns off the HV bias")
    public void hvBiasOff() throws PowerException {
        this.hvBiasOff(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hvBiasOff(boolean disable) throws PowerException {
        Object object = this.hvBiasOnOffLock;
        synchronized (object) {
            this.disableRebHvBiasOn = disable;
            this.powerSupplyDevice.setPowerOn(this.channel, RebPsEnum.HVBIAS.getNumber(), false);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Read the HvBias DAC value")
    public double readHvBiasDac() throws PowerException {
        return this.powerSupplyDevice.getDacs(true)[this.channel];
    }

    @Command(type=Command.CommandType.QUERY, description="Read a channel's maximum & minimum values")
    public double[] getChanExtrema(@Argument(description="PS name") RebPsDevice.PsName psName, @Argument(description="Channel name") RebPsDevice.ChanName chan) throws PowerException {
        return this.powerSupplyDevice.readChanExtrema(this.channel, psName, chan);
    }

    @Command(type=Command.CommandType.ACTION, description="Reset a channel's maximum & minimum values")
    public void resetChanExtrema(@Argument(description="PS name") RebPsDevice.PsName psName, @Argument(description="Channel name") RebPsDevice.ChanName chan) throws PowerException {
        this.powerSupplyDevice.resetChanExtrema(this.channel, psName, chan);
    }

    RebPsDevice getRebPsDevice() {
        return this.powerSupplyDevice;
    }

    Channel getPowerChannel() {
        return this.powerChannel;
    }

    synchronized void processEmergencyResponse(String origin, Alert alert, RebPowerAction rebPowerAction) {
        if (rebPowerAction != null && this.rebPath.equals(rebPowerAction.getRebPath())) {
            this.agent.getScheduler().execute(() -> {
                switch (rebPowerAction.getType()) {
                    case TURN_REB_HVBIAS_OFF: {
                        LOG.log(Level.WARNING, "Turning HVBias OFF for reb {0}", this.rebPath);
                        try {
                            this.hvBiasOff(true);
                        }
                        catch (PowerException pe) {
                            LOG.log(Level.SEVERE, "Could not turn HVBias OFF for reb " + this.rebPath, pe);
                            this.alertService.raiseAlert(RebPowerAlarm.getRebPowerAlert(RebPowerAlertType.EMERGENCY_ACTION_FAILED, this.rebPath), AlertState.ALARM, "Could not turn HVBias OFF for reb " + this.rebPath);
                        }
                        break;
                    }
                    case TURN_REB_OFF: {
                        LOG.log(Level.WARNING, "Turning Power OFF for reb {0}", this.rebPath);
                        try {
                            this.powerRebOff(true);
                        }
                        catch (PowerException pe) {
                            LOG.log(Level.SEVERE, "Could not turn Power OFF for reb " + this.rebPath, pe);
                            this.alertService.raiseAlert(RebPowerAlarm.getRebPowerAlert(RebPowerAlertType.EMERGENCY_ACTION_FAILED, this.rebPath), AlertState.ALARM, "Could not turn Power OFF for reb " + this.rebPath);
                        }
                        break;
                    }
                    default: {
                        LOG.log(Level.SEVERE, "Unknown Reb Power Action {0} for Reb path {1}", new Object[]{rebPowerAction.getType(), this.rebPath});
                    }
                }
            });
        }
    }

    void updateEmergencyState(RebPowerAction.Type actionType, List<String> outstandingAlerts) {
        this.outstandingAlerts.put(actionType, outstandingAlerts);
        if (outstandingAlerts.isEmpty()) {
            switch (actionType) {
                case TURN_REB_HVBIAS_OFF: {
                    LOG.log(Level.INFO, "Enabling hvBiasOn command for {0}", this.rebPath);
                    this.disableRebHvBiasOn = false;
                    break;
                }
                case TURN_REB_OFF: {
                    LOG.log(Level.INFO, "Enabling powerRebOn command for {0}", this.rebPath);
                    this.disableRebPowerOn = false;
                }
            }
        }
    }
}

