/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.airwatch.main.AnalogPoint;
import org.lsst.ccs.subsystem.airwatch.main.CounterPoint;
import org.lsst.ccs.subsystem.airwatch.main.DataPoint;
import org.lsst.ccs.subsystem.airwatch.main.Location;
import org.lsst.ccs.subsystem.airwatch.main.LocationStatus;
import org.lsst.ccs.utilities.logging.Logger;

public class RestfulLocation
implements Location {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.airwatch");
    private final boolean enabled;
    private final String location;
    private final Instant lastDataTime;
    private final Map<String, DataPoint> points;

    public RestfulLocation(Map<String, Object> locData, Set<String> enabled) {
        this.location = (String)locData.get("location");
        this.enabled = enabled.contains(this.location);
        this.lastDataTime = Instant.now();
        this.points = new HashMap<String, DataPoint>();
        for (String key : locData.keySet()) {
            if (key.equals("location")) continue;
            this.makeDataPoint(key, (Map)locData.get(key));
        }
    }

    private RestfulLocation(boolean enabled, String location, Instant lastDataTime, Map<String, DataPoint> points) {
        this.enabled = enabled;
        this.location = location;
        this.lastDataTime = lastDataTime;
        this.points = points;
    }

    @Override
    public final LocationStatus getStatus() {
        return new LocationStatus(this.enabled, this.location, this.lastDataTime);
    }

    @Override
    public final Map<String, DataPoint> getDataPoints() {
        return Collections.unmodifiableMap(this.points);
    }

    @Override
    public final Location disable() {
        return new RestfulLocation(false, this.location, this.lastDataTime, this.points);
    }

    @Override
    public final Location enable() {
        return new RestfulLocation(true, this.location, this.lastDataTime, this.points);
    }

    @Override
    public final void checkData(AlertService alertSvc) {
        for (String chanName : this.points.keySet()) {
            DataPoint p = this.points.get(chanName);
            p.checkData(alertSvc, this.location, chanName, this.enabled);
        }
    }

    @Override
    public final void publishGoodData(Subsystem subsys) {
        for (String chanName : this.points.keySet()) {
            DataPoint p = this.points.get(chanName);
            if (!p.getQuality().equals("Good") || p.hasMalfunction()) continue;
            KeyValueDataList kvdl = p.makeKvdList(this.location, chanName);
            subsys.publishSubsystemDataOnStatusBus((KeyValueData)p.makeKvdList(this.location, chanName));
        }
    }

    private void makeDataPoint(String chanName, Map<String, Object> chanData) {
        if (Character.isDigit(chanName.charAt(0))) {
            this.points.put(chanName, new CounterPoint((Double)chanData.get("absolute"), (Double)chanData.get("density"), (Boolean)chanData.get("limitViolation"), (Boolean)chanData.get("malfunction"), (String)chanData.get("quality"), (String)chanData.get("time")));
        } else {
            this.points.put(chanName, new AnalogPoint((Double)chanData.get("value"), (Boolean)chanData.get("limitViolation"), (Boolean)chanData.get("malfunction"), (String)chanData.get("quality"), (String)chanData.get("time"), (Double)chanData.get("lowBound"), (Double)chanData.get("highBound")));
        }
    }
}

