/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.auxelex.SrpException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.utilities.conv.Convert;

public class Srp {
    private static final Logger LOG = Logger.getLogger(Srp.class.getName());
    public static final int DEFAULT_PORT = 8192;
    public static final int PORT_0 = 8192;
    public static final int PORT_1 = 8193;
    public static final int PORT_2 = 8194;
    public static final int PORT_3 = 8195;
    private static final int MAX_REGS = 64;
    private static final int MAX_REGS_3 = 1024;
    private static final int READ_WARN = 500;
    private static final int READ_TIMEOUT = 1000;
    private static final int SRP_PKT_LENG = 20;
    private static final int SRP_OFF_HEADER = 4;
    private static final int SRP_OFF_OC = 8;
    private static final int SRP_OFF_ADDR = 8;
    private static final int SRP_OFF_DATA = 12;
    private static final int SRP_OFF_FOOTER = 16;
    private static final int SRP3_PKT_LENG = 20;
    private static final int SRP3_OFF_HEADER = 0;
    private static final int SRP3_OFF_VERSION = 0;
    private static final int SRP3_OFF_OPCODE = 1;
    private static final int SRP3_OFF_TIMEOUT = 3;
    private static final int SRP3_OFF_TID = 4;
    private static final int SRP3_OFF_ADDR_LO = 8;
    private static final int SRP3_OFF_ADDR_HI = 12;
    private static final int SRP3_OFF_SIZE = 16;
    private static final int SRP3_OFF_DATA = 20;
    private static final int SRP3_OFF_FOOTER = 20;
    private static final int SRP3_OPC_NP_READ = 0;
    private static final int SRP3_OPC_NP_WRITE = 1;
    private static final int SRP3_OPC_P_WRITE = 2;
    private static final byte SRP_OC_READ = 0;
    private static final byte SRP_OC_WRITE = 64;
    private static final int REG_FPGA_VERSION = 458752;
    private static final int REG_SCRATCH_PAD = 458753;
    private static final int REG_UP_TIME_SECS = 458754;
    private static final int REG_FPGA_RELOAD = 458817;
    private static final int REG_USER_RESET = 458819;
    private static final int REG_BOARD_ID = 459009;
    private static final int ID_REB_PS_SCIENCE_A = 0;
    private static final int ID_REB_PS_SCIENCE_B = 2;
    private static final int ID_REB_PS_CORNER_A = 1;
    private static final int ID_REB_PS_CORNER_B = 3;
    private static final int ID_PDU_5V_A = 32;
    private static final int ID_PDU_5V_B = 33;
    private static final int ID_PDU_5V_C = 34;
    private static final int ID_PDU_24V_DIRTY_A = 17;
    private static final int ID_PDU_24V_DIRTY_B = 20;
    private static final int ID_PDU_24V_DIRTY_C = 23;
    private static final int ID_PDU_24V_CLEAN_A = 18;
    private static final int ID_PDU_24V_CLEAN_B = 21;
    private static final int ID_PDU_24V_CLEAN_C = 24;
    private static final int ID_PDU_48V_A = 16;
    private static final int ID_PDU_48V_B = 19;
    private static final int ID_PDU_48V_C = 22;
    private static final int ID_ION_PUMP_A = 48;
    private static final int ID_ION_PUMP_B = 49;
    private static final int ID_HEATER_A = 64;
    private static final int ID_BFR_A = 80;
    private static final int REG_BUILD_STAMP = 459264;
    private static final int LEN_BUILD_STAMP = 64;
    private static final Map<Integer, BoardType> boardIdMap = new HashMap<Integer, BoardType>();
    protected BoardType boardType;
    private DatagramSocket sock;
    private int seqno;
    private int nSeqErr;
    private int nTimeout;
    private int srpVersion = 3;
    private int maxRegs = 1024;
    private byte[] inBuff = new byte[20 + 4 * (this.maxRegs - 1)];
    private byte[] outBuff = new byte[20 + 4 * (this.maxRegs - 1)];
    private DatagramPacket inPkt = new DatagramPacket(this.inBuff, this.inBuff.length);
    private DatagramPacket outPkt = new DatagramPacket(this.outBuff, this.outBuff.length);
    private byte[] ipAddr;
    private boolean simulated;
    private boolean debug;
    private final Map<Integer, Integer> simRegMap = new HashMap<Integer, Integer>();
    private Collection<BoardType> validBoardTypes;
    private int readTimeout = 1000;
    private int readWarn = 500;
    private String logName;

    public Srp(String logName) {
        this.logName = logName;
    }

    public Srp() {
        this(null);
    }

    public final void setLogName(String logName) {
        this.logName = logName;
    }

    public final void setValidBoardTypes(Collection types) {
        this.validBoardTypes = types;
    }

    public final void setSrpVersion(int version) {
        if (version == this.srpVersion) {
            return;
        }
        this.srpVersion = version;
        this.maxRegs = this.srpVersion == 3 ? 1024 : 64;
        int pktLeng = this.srpVersion == 3 ? 20 : 20;
        this.inBuff = new byte[pktLeng + 4 * (this.maxRegs - 1)];
        this.outBuff = new byte[pktLeng + 4 * (this.maxRegs - 1)];
        this.inPkt = new DatagramPacket(this.inBuff, this.inBuff.length);
        this.outPkt = new DatagramPacket(this.outBuff, this.outBuff.length);
    }

    public synchronized void open(String host, int port) throws DriverException {
        if (this.sock != null) {
            throw new SrpException(this.logName, "Connection is already open");
        }
        this.nSeqErr = 0;
        this.nTimeout = 0;
        try {
            DatagramSocket newSock = new DatagramSocket();
            if (host == null || host.isEmpty()) {
                this.simulated = true;
                this.ipAddr = new byte[]{0, 0, 0, 0};
                this.simInitialize();
            } else {
                this.simulated = false;
                int actPort = port == 0 ? 8192 : port;
                InetAddress inetAddr = InetAddress.getByName(host);
                newSock.connect(inetAddr, actPort);
                newSock.setSoTimeout(this.readTimeout);
                this.outPkt.setAddress(inetAddr);
                this.outPkt.setPort(actPort);
                this.ipAddr = inetAddr.getAddress();
            }
            this.sock = newSock;
            try {
                this.setBoardType();
            }
            catch (DriverException e) {
                this.close();
                throw e;
            }
        }
        catch (IOException e) {
            throw new SrpException(this.logName, "IOException during open", e);
        }
    }

    public void open(String host) throws DriverException {
        this.open(host, 0);
    }

    public void open(int node, int port) throws DriverException {
        this.open(node == 0 ? null : "192.168.1." + node, port);
    }

    public void open(int node) throws DriverException {
        this.open(node, 0);
    }

    public void close() throws DriverException {
        this.checkOpen();
        this.sock.close();
        this.sock = null;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
        if (this.sock != null) {
            try {
                this.sock.setSoTimeout(timeout);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Error setting socket timeout: {0}", e.getMessage());
            }
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadWarning(int time) {
        this.readWarn = time;
    }

    public int getReadWarning() {
        return this.readWarn;
    }

    private void setBoardType() throws DriverException {
        if (this.simulated) {
            this.boardType = BoardType.SIMULATED;
        } else {
            int type = this.readReg(459009);
            BoardType boardType = this.boardType = type != 0 ? boardIdMap.get(type & 0xFF) : null;
            if (this.boardType == null) {
                this.boardType = BoardType.UNKNOWN;
            }
        }
        if (this.validBoardTypes != null && !this.validBoardTypes.contains((Object)this.boardType)) {
            throw new SrpException(this.logName, "Invalid board type: " + (Object)((Object)this.boardType));
        }
    }

    public BoardType getBoardType() {
        return this.boardType;
    }

    public String getBuildStamp() throws DriverException {
        int len;
        int[] data = this.readRegs(459264, 64);
        byte[] bData = new byte[256];
        for (int j = 0; j < data.length; ++j) {
            Convert.intToBytes((int)data[j], (byte[])bData, (int)(4 * j));
        }
        for (len = 0; len < bData.length && bData[len] != 0; ++len) {
        }
        return new String(bData, 0, len);
    }

    public int getFpgaVersion() throws DriverException {
        return this.readReg(458752);
    }

    public int getUpTime() throws DriverException {
        return this.readReg(458754);
    }

    public void writeScratchPad(int value) throws DriverException {
        this.writeReg(458753, value);
    }

    public int readScratchPad() throws DriverException {
        return this.readReg(458753);
    }

    public void userReset() throws DriverException {
        this.writeReg(458819, 1);
        this.writeReg(458819, 0);
    }

    public void reloadFpga() throws DriverException {
        this.writeReg(458817, 1);
    }

    public void setDebug(Boolean on) {
        this.debug = on;
    }

    public byte[] getIpAddress() {
        return this.ipAddr;
    }

    public int getNode() {
        return this.ipAddr[3] & 0xFF;
    }

    public boolean isSimulated() {
        return this.simulated;
    }

    public void writeReg(int addr, int value) throws DriverException {
        this.writeRegs(addr, new int[]{value});
    }

    public synchronized void writeRegs(int addr, int[] value) throws DriverException {
        this.checkOpen();
        int count = Math.min(value.length, this.maxRegs);
        try {
            if (this.simulated) {
                this.simWriteRegs(addr, value, count);
            } else if (this.srpVersion == 3) {
                this.writeRegs3(addr, value, count);
            } else {
                this.writeRegs0(addr, value, count);
            }
        }
        catch (SrpException x) {
            x.addDetails(String.format("While writing addr=%x values=%s", addr, Arrays.toString(value)));
            throw x;
        }
    }

    private void writeRegs3(int addr, int[] value, int count) throws DriverException {
        int j;
        Convert.intToBytes((int)(4 * addr), (byte[])this.outBuff, (int)8);
        Convert.intToBytes((int)0, (byte[])this.outBuff, (int)12);
        Convert.intToBytes((int)(4 * count - 1), (byte[])this.outBuff, (int)16);
        for (j = 0; j < count; ++j) {
            Convert.intToBytes((int)value[j], (byte[])this.outBuff, (int)(20 + 4 * j));
        }
        this.outBuff[0] = 3;
        this.outBuff[1] = 1;
        this.outBuff[3] = 10;
        for (j = 0; j < 2; ++j) {
            try {
                this.send(20 + 4 * count);
                this.receive();
                break;
            }
            catch (DriverTimeoutException e) {
                if (j != 1) continue;
                throw e;
            }
        }
    }

    private void writeRegs0(int addr, int[] value, int count) throws DriverException {
        int j;
        Convert.intToBytesBE((int)addr, (byte[])this.outBuff, (int)8);
        for (j = 0; j < count; ++j) {
            Convert.intToBytesBE((int)value[j], (byte[])this.outBuff, (int)(12 + 4 * j));
        }
        this.outBuff[8] = 64;
        for (j = 0; j < 2; ++j) {
            try {
                this.send(20 + 4 * (count - 1));
                this.receive();
                break;
            }
            catch (DriverTimeoutException e) {
                if (j != 1) continue;
                throw e;
            }
        }
    }

    public int readReg(int addr) throws DriverException {
        return this.readRegs(addr, 1)[0];
    }

    public synchronized int[] readRegs(int addr, int count) throws DriverException {
        this.checkOpen();
        if (count <= 0) {
            return new int[0];
        }
        count = Math.min(count, this.maxRegs);
        try {
            if (this.simulated) {
                return this.simReadRegs(addr, count);
            }
            if (this.srpVersion == 3) {
                return this.readRegs3(addr, count);
            }
            return this.readRegs0(addr, count);
        }
        catch (SrpException x) {
            x.addDetails(String.format("While reading addr=%x count=%d", addr, count));
            throw x;
        }
    }

    private int[] readRegs3(int addr, int count) throws DriverException {
        this.outBuff[0] = 3;
        this.outBuff[1] = 0;
        this.outBuff[3] = 10;
        Convert.intToBytes((int)(4 * addr), (byte[])this.outBuff, (int)8);
        Convert.intToBytes((int)0, (byte[])this.outBuff, (int)12);
        Convert.intToBytes((int)(4 * count - 1), (byte[])this.outBuff, (int)16);
        for (int j = 0; j < 2; ++j) {
            try {
                this.send(20);
                this.receive();
                break;
            }
            catch (DriverTimeoutException e) {
                if (j != 1) continue;
                throw e;
            }
        }
        int nRead = (this.inPkt.getLength() - 20) / 4 - 1;
        int[] data = new int[nRead];
        for (int j = 0; j < nRead; ++j) {
            data[j] = Convert.bytesToInt((byte[])this.inBuff, (int)(20 + 4 * j));
        }
        return data;
    }

    private int[] readRegs0(int addr, int count) throws DriverException {
        Convert.intToBytesBE((int)addr, (byte[])this.outBuff, (int)8);
        Convert.intToBytesBE((int)(count - 1), (byte[])this.outBuff, (int)12);
        this.outBuff[8] = 0;
        for (int j = 0; j < 2; ++j) {
            try {
                this.send(20);
                this.receive();
                break;
            }
            catch (DriverTimeoutException e) {
                if (j != 1) continue;
                throw e;
            }
        }
        int nRead = (this.inPkt.getLength() - 20) / 4 + 1;
        int[] data = new int[nRead];
        for (int j = 0; j < nRead; ++j) {
            data[j] = Convert.bytesToIntBE((byte[])this.inBuff, (int)(12 + 4 * j));
        }
        return data;
    }

    public synchronized int updateReg(int addr, int mask, int value) throws DriverException {
        int prevValue = this.readReg(addr);
        this.writeReg(addr, prevValue & ~mask | value & mask);
        return prevValue;
    }

    void checkOpen() throws DriverException {
        if (this.sock == null) {
            throw new DriverException("Connection is not open");
        }
    }

    private void send(int leng) throws DriverException {
        this.seqno += 4;
        Convert.intToBytes((int)this.seqno, (byte[])this.outBuff, (int)(this.srpVersion == 3 ? 4 : 4));
        if (this.srpVersion != 3) {
            Convert.intToBytes((int)0, (byte[])this.outBuff, (int)(leng - 20 + 16));
        }
        this.showData("Sent:", leng, this.outBuff);
        this.outPkt.setLength(leng);
        try {
            this.sock.send(this.outPkt);
        }
        catch (IOException e) {
            throw new SrpException(this.logName, "IOException during send", e);
        }
    }

    private void receive() throws DriverException {
        long start = System.currentTimeMillis();
        while (true) {
            this.inPkt.setLength(this.inBuff.length);
            try {
                this.sock.receive(this.inPkt);
                int rSeqno = Convert.bytesToInt((byte[])this.inBuff, (int)(this.srpVersion == 3 ? 4 : 4));
                if (this.seqno == rSeqno) break;
                LOG.log(Level.WARNING, () -> String.format("%sDiscarded unexpected packet seqno %x", this.formatLogName(), rSeqno));
                ++this.nSeqErr;
            }
            catch (SocketTimeoutException e) {
                ++this.nTimeout;
                throw new SrpException.SrpTimeoutException(this.logName, "Timeout during receive", e);
            }
            catch (IOException e) {
                throw new SrpException(this.logName, "IOException during receive", e);
            }
        }
        long timeToRead = System.currentTimeMillis() - start;
        if (timeToRead > (long)this.readWarn) {
            LOG.log(Level.WARNING, () -> String.format("%sRead of seqno %x took unexpectedly long time %dms", this.formatLogName(), this.seqno, timeToRead));
        }
        int leng = this.inPkt.getLength();
        this.showData("Rcvd:", leng, this.inBuff);
        if (this.srpVersion == 3) {
            int status = Convert.bytesToInt((byte[])this.inBuff, (int)(leng - 4));
            if (status != 0) {
                throw SrpException.create3(this.logName, status);
            }
        } else {
            int status = Convert.bytesToIntBE((byte[])this.inBuff, (int)(leng + 16 - 20));
            if (status != 0) {
                throw SrpException.create0(this.logName, status);
            }
        }
    }

    private String formatLogName() {
        return Srp.formatLogName(this.logName);
    }

    static String formatLogName(String logName) {
        return logName == null ? "" : logName + ": ";
    }

    private void showData(String title, int length, byte[] data) {
        Supplier<String> messageBuilder = () -> {
            StringBuilder builder = new StringBuilder();
            String blanks = "\n" + title.replaceAll(".", " ");
            for (int j = 0; j < length; ++j) {
                if (j % 32 == 0) {
                    if (j == 0) {
                        builder.append(title);
                    } else {
                        builder.append(blanks);
                    }
                }
                if (j % 4 == 0) {
                    builder.append(" ");
                }
                builder.append(String.format("%02x", data[j] & 0xFF));
            }
            return builder.toString();
        };
        if (this.debug) {
            System.out.println(messageBuilder.get());
        } else {
            LOG.log(Level.FINEST, () -> this.formatLogName() + (String)messageBuilder.get());
        }
    }

    public int getNumSeqErr() {
        return this.nSeqErr;
    }

    public int getNumTimeout() {
        return this.nTimeout;
    }

    protected void simInitialize() {
        this.clearSimRegMap();
    }

    protected void simWriteRegs(int addr, int[] value, int count) {
        int j = 0;
        while (j < count) {
            this.putSimRegMap(addr, value[j]);
            ++j;
            ++addr;
        }
    }

    protected int[] simReadRegs(int addr, int count) {
        int[] data = new int[count];
        for (int j = 0; j < count; ++j) {
            data[j] = this.getSimRegMap(addr + j);
        }
        return data;
    }

    protected final void clearSimRegMap() {
        this.simRegMap.clear();
    }

    protected final void putSimRegMap(int addr, int value) {
        this.simRegMap.put(addr, value);
    }

    protected final int getSimRegMap(int addr) {
        Integer value = this.simRegMap.get(addr);
        return value == null ? 0 : value;
    }

    static {
        boardIdMap.put(0, BoardType.REB_PS_PROD_SR);
        boardIdMap.put(2, BoardType.REB_PS_PROD_SR);
        boardIdMap.put(1, BoardType.REB_PS_PROD_CR);
        boardIdMap.put(3, BoardType.REB_PS_PROD_CR);
        boardIdMap.put(32, BoardType.PDU_5V);
        boardIdMap.put(33, BoardType.PDU_5V);
        boardIdMap.put(34, BoardType.PDU_5V);
        boardIdMap.put(18, BoardType.PDU_24V_CLEAN);
        boardIdMap.put(21, BoardType.PDU_24V_CLEAN);
        boardIdMap.put(24, BoardType.PDU_24V_CLEAN);
        boardIdMap.put(17, BoardType.PDU_24V_DIRTY);
        boardIdMap.put(20, BoardType.PDU_24V_DIRTY);
        boardIdMap.put(23, BoardType.PDU_24V_DIRTY);
        boardIdMap.put(16, BoardType.PDU_48V);
        boardIdMap.put(19, BoardType.PDU_48V);
        boardIdMap.put(22, BoardType.PDU_48V);
        boardIdMap.put(48, BoardType.ION_PUMP);
        boardIdMap.put(49, BoardType.ION_PUMP);
        boardIdMap.put(64, BoardType.HEATER);
        boardIdMap.put(80, BoardType.BFR);
    }

    public static enum BoardType {
        UNKNOWN,
        SIMULATED,
        REB_PS_PROTO,
        REB_PS_UPDATE,
        REB_PS_PROD_SR,
        REB_PS_PROD_CR,
        PDU_5V,
        PDU_24V_DIRTY,
        PDU_24V_CLEAN,
        PDU_48V,
        BFR,
        ION_PUMP,
        HEATER;

    }
}

