/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cablerotator;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.utilities.logging.Logger;

public class MockAscii
extends Ascii {
    private int planeStatus = 0;
    private int xStatus = 3;
    private int xFault = 0;
    private double xPos = 0.0;
    private int taskStatus = 0;
    private Instant stopTime = null;
    private final Map<Integer, Double> dglobal = new HashMap<Integer, Double>();
    private final Map<Integer, Integer> iglobal = new HashMap<Integer, Integer>();
    private static final Logger LOG = Logger.getLogger((String)MockAscii.class.getName());

    public synchronized void setTimeout(int time) throws DriverException {
    }

    public void setTimeout(double time) throws DriverException {
    }

    public void setTerminator(Ascii.Terminator term) {
    }

    public void setCommandTerm(Ascii.Terminator term) {
    }

    public void setResponseTerm(Ascii.Terminator term) {
    }

    public synchronized void flush() throws DriverException {
    }

    public int readBytes(byte[] buff, int offset, int leng) throws DriverException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int readBytes(byte[] buff, int offset) throws DriverException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void writeBytes(byte[] command, int offset, int leng) throws DriverException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void writeBytes(byte[] command) throws DriverException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public synchronized String read(String command) throws DriverException {
        this.updateStatus();
        if (command.startsWith("DGLOBAL")) {
            return this.doDglobal(command);
        }
        if (command.startsWith("IGLOBAL")) {
            return this.doIglobal(command);
        }
        if (command.startsWith("AXISSTATUS")) {
            return this.doAxisStatus(command);
        }
        if (command.startsWith("AXISFAULT")) {
            return this.doAxisFault(command);
        }
        if (command.startsWith("TASKSTATE")) {
            return this.doTaskStatus(command);
        }
        if (command.contains("Move.bcx")) {
            return this.doMove(command);
        }
        if (command.contains("HomeAsync.bcx")) {
            return this.doHome(command);
        }
        if (command.startsWith("PROGRAM STOP")) {
            return this.doStop(command);
        }
        if (command.startsWith("ABORT")) {
            return this.doAbort(command);
        }
        if (command.startsWith("PLANESTATUS")) {
            return this.doPlaneStatus(command);
        }
        if (command.startsWith("PFBK")) {
            return this.doPositionQuery(command);
        }
        LOG.info((Object)command);
        return "%0";
    }

    public synchronized String read() throws DriverException {
        LOG.info((Object)"Read()");
        return "%0";
    }

    public synchronized void write(String command) throws DriverException {
        LOG.info((Object)("Write(): " + command));
    }

    public boolean closeSilent() {
        return true;
    }

    public synchronized void close() throws DriverException {
    }

    public void openFtdi(String serialNo, int baudRate) throws DriverException {
    }

    public void openFtdi(String serialNo, int baudRate, int dataChar) throws DriverException {
    }

    public void openSerial(String devcName, int baudRate) throws DriverException {
    }

    public void openSerial(String devcName, int baudRate, int dataChar) throws DriverException {
    }

    public void openNet(String host, int port) throws DriverException {
    }

    public void open(DriverConstants.ConnType type, String ident, int parm) throws DriverException {
    }

    public synchronized void open(DriverConstants.ConnType type, String ident, int parm1, int parm2) throws DriverException {
    }

    private void updateStatus() {
        if (this.stopTime != null && Instant.now().isAfter(this.stopTime)) {
            this.stopTime = null;
            this.taskStatus = 0;
            this.planeStatus = 0;
            this.xStatus = 3;
            this.dglobal.put(0, 0.0);
        }
    }

    private String doDglobal(String command) {
        ParsedGlobal pg = new ParsedGlobal(command);
        if (pg.value != null) {
            this.dglobal.put(pg.index, Double.valueOf(pg.value));
            return "%";
        }
        return "%" + this.getDglobal(pg.index);
    }

    private Double getDglobal(int index) {
        Double result = this.dglobal.get(index);
        if (result == null) {
            result = 0.0;
        }
        return result;
    }

    private String doIglobal(String command) {
        ParsedGlobal pg = new ParsedGlobal(command);
        if (pg.value != null) {
            this.iglobal.put(pg.index, Integer.valueOf(pg.value));
            return "%";
        }
        return "%" + this.getIglobal(pg.index);
    }

    private Integer getIglobal(int index) {
        Integer result = this.iglobal.get(index);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    private String doAxisStatus(String command) {
        LOG.info((Object)command);
        if (command.contains("(THETA)")) {
            return "%" + this.xStatus;
        }
        return "!";
    }

    private String doAxisFault(String command) {
        LOG.info((Object)command);
        if (command.contains("(THETA)")) {
            return "%" + this.xFault;
        }
        return "!";
    }

    private String doPlaneStatus(String command) {
        LOG.info((Object)command);
        return "%" + this.planeStatus;
    }

    private String doTaskStatus(String command) {
        LOG.info((Object)command);
        return "%" + this.taskStatus;
    }

    private String doStop(String command) {
        LOG.info((Object)command);
        this.stopTime = null;
        this.xStatus = 3;
        this.planeStatus = 0;
        this.taskStatus = 0;
        this.dglobal.put(0, 0.0);
        return "%";
    }

    private String doAbort(String command) {
        LOG.info((Object)command);
        this.stopTime = null;
        this.xStatus = 3;
        this.planeStatus = 0;
        this.taskStatus = 0;
        this.dglobal.put(0, 0.0);
        return "%";
    }

    private String doMove(String command) {
        LOG.info((Object)command);
        int axisNum = this.getDglobal(0).intValue();
        long moveMillis = (long)Math.min(10000.0, 800.0 * this.getDglobal(4));
        double newPos = this.getDglobal(1);
        if (axisNum == 0) {
            this.stopTime = Instant.now().plusMillis(moveMillis);
            this.taskStatus = 3;
            this.xStatus |= 8;
            this.xPos = newPos;
        }
        return "%";
    }

    private String doHome(String command) {
        LOG.info((Object)command);
        int axisNum = this.getIglobal(32);
        this.taskStatus = 3;
        if (axisNum == 0) {
            this.xStatus |= 8;
            this.stopTime = Instant.now().plusSeconds(10L);
        }
        return "%";
    }

    private String doPositionQuery(String command) {
        LOG.info((Object)command);
        if (command.contains("(THETA)")) {
            return "%" + this.xPos;
        }
        return "!";
    }

    private static class ParsedGlobal {
        public final int index;
        public final String value;

        ParsedGlobal(String command) {
            LOG.info((Object)command);
            int eqpos = command.indexOf("=");
            int lpos = command.indexOf("(");
            int rpos = command.indexOf(")");
            this.index = Integer.valueOf(command.substring(lpos + 1, rpos));
            this.value = eqpos > 0 ? command.substring(eqpos + 1) : null;
        }
    }
}

