/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.visualization.client;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.lsst.ccs.visualization.client.Message;

public class HeaderMessage
extends Message {
    private final String card;

    public HeaderMessage(String imageName, String card) {
        super(Message.MessageType.HEADER, card.length(), imageName);
        this.card = card;
    }

    @Override
    void encodeAdditional(ByteBuffer bb) {
        bb.put(this.card.getBytes(StandardCharsets.US_ASCII));
    }

    static Message decode(ByteBuffer bb, CharSequence name) {
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bytes);
        String card = new String(bytes, StandardCharsets.US_ASCII);
        return new HeaderMessage(name.toString(), card);
    }

    public String getCard() {
        return this.card;
    }

    public String toString() {
        return "HeaderMessage{imageName=" + this.getImageName() + ", card=" + this.card + '}';
    }
}

