/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.Domain;
import org.opensplice.dds.dcps.DomainBase;
import org.opensplice.dds.dcps.ReportStack;

public class DomainImpl
extends DomainBase
implements Domain {
    private static final long serialVersionUID = 6683917520488717432L;
    private int domainId = 0;

    protected DomainImpl() {
    }

    protected int init(int domainId) {
        int result;
        long uDomain = this.jniDomainNew(domainId);
        if (uDomain != 0L) {
            this.set_user_object(uDomain);
            this.domainId = domainId;
            this.setDomainId(domainId);
            result = 0;
        } else {
            result = 3;
            ReportStack.report(result, "Could not locate a domain with domainId = " + domainId + ".");
        }
        return result;
    }

    @Override
    protected int deinit() {
        long uDomain = 0L;
        int result = 9;
        uDomain = this.get_user_object();
        if (uDomain != 0L && (result = this.jniDomainFree(uDomain)) == 0) {
            result = super.deinit();
        }
        return result;
    }

    public int get_domain_id() {
        return this.domainId;
    }

    @Override
    public int create_persistent_snapshot(String partition_expression, String topic_expression, String URI) {
        int result = 0;
        long uDomain = 0L;
        ReportStack.start();
        if (partition_expression == null) {
            result = 3;
            ReportStack.report(result, "partition_expression 'null' is invalid.");
        } else if (topic_expression == null) {
            result = 3;
            ReportStack.report(result, "topic_expression 'null' is invalid.");
        } else if (URI == null) {
            result = 3;
            ReportStack.report(result, "URI 'null' is invalid.");
        } else {
            uDomain = this.get_user_object();
            result = uDomain != 0L ? this.jniCreatePersistentSnapshot(uDomain, partition_expression, topic_expression, URI) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    private native long jniDomainNew(int var1);

    private native int jniDomainFree(long var1);

    private native int jniDomainId(long var1);

    private native int jniCreatePersistentSnapshot(long var1, String var3, String var4, String var5);
}

