/*
 * Decompiled with CFR 0.152.
 */
package DDS.IoT;

import DDS.IoT.IoTData;
import DDS.IoT.IoTDataDataWriter;
import DDS.IoT.IoTDataHolder;
import DDS.IoT.IoTDataTypeSupport;
import DDS.Time_t;
import org.opensplice.dds.dcps.DataWriterImpl;
import org.opensplice.dds.dcps.FooDataWriterImpl;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.Utilities;

public class IoTDataDataWriterImpl
extends DataWriterImpl
implements IoTDataDataWriter {
    private static final long serialVersionUID = 1L;
    private long copyCache;
    private IoTDataTypeSupport typeSupport;

    public IoTDataDataWriterImpl(IoTDataTypeSupport ts) {
        this.typeSupport = ts;
        this.copyCache = this.typeSupport.get_copyCache();
    }

    @Override
    public long register_instance(IoTData instance_data) {
        long uWriter = 0L;
        long handle = 0L;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L) {
            if (instance_data == null) {
                ReportStack.report(3, "instance_data 'null' is invalid.");
            } else {
                handle = FooDataWriterImpl.jniRegisterInstance(uWriter, this.copyCache, instance_data, Utilities.DDS_TIMESTAMP_CURRENT);
            }
        }
        ReportStack.flush(this, handle == 0L);
        return handle;
    }

    @Override
    public long register_instance_w_timestamp(IoTData instance_data, Time_t source_timestamp) {
        int result = 9;
        long uWriter = 0L;
        long handle = 0L;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L) {
            if (instance_data == null) {
                result = 3;
                ReportStack.report(result, "instance_data 'null' is invalid.");
            } else {
                result = Utilities.checkTime(source_timestamp);
            }
            if (result == 0) {
                handle = FooDataWriterImpl.jniRegisterInstance(uWriter, this.copyCache, instance_data, source_timestamp);
            }
        }
        ReportStack.flush(this, handle == 0L);
        return handle;
    }

    @Override
    public int unregister_instance(IoTData instance_data, long handle) {
        int result = 9;
        long uWriter = 0L;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L) {
            result = FooDataWriterImpl.jniUnregisterInstance(uWriter, this.copyCache, instance_data, handle, Utilities.DDS_TIMESTAMP_CURRENT);
        }
        ReportStack.flush(this, result != 0 && result != 10);
        return result;
    }

    @Override
    public int unregister_instance_w_timestamp(IoTData instance_data, long handle, Time_t source_timestamp) {
        int result = 9;
        long uWriter = 0L;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L && (result = Utilities.checkTime(source_timestamp)) == 0) {
            result = FooDataWriterImpl.jniUnregisterInstance(uWriter, this.copyCache, instance_data, handle, source_timestamp);
        }
        ReportStack.flush(this, result != 0 && result != 10);
        return result;
    }

    @Override
    public int write(IoTData instance_data, long handle) {
        int result = 9;
        long uWriter = 0L;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L) {
            if (instance_data == null) {
                result = 3;
                ReportStack.report(result, "instance_data 'null' is invalid.");
            } else {
                result = FooDataWriterImpl.jniWrite(uWriter, this.copyCache, instance_data, handle, Utilities.DDS_TIMESTAMP_CURRENT);
            }
        }
        ReportStack.flush(this, result != 0 && result != 10);
        return result;
    }

    @Override
    public int write_w_timestamp(IoTData instance_data, long handle, Time_t source_timestamp) {
        int result = 9;
        long uWriter = 0L;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L) {
            if (instance_data == null) {
                result = 3;
                ReportStack.report(result, "instance_data 'null' is invalid.");
            } else {
                result = Utilities.checkTime(source_timestamp);
            }
            if (result == 0) {
                result = FooDataWriterImpl.jniWrite(uWriter, this.copyCache, instance_data, handle, source_timestamp);
            }
        }
        ReportStack.flush(this, result != 0 && result != 10);
        return result;
    }

    @Override
    public int dispose(IoTData instance_data, long instance_handle) {
        int result = 9;
        long uWriter = 0L;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L) {
            result = FooDataWriterImpl.jniDispose(uWriter, this.copyCache, instance_data, instance_handle, Utilities.DDS_TIMESTAMP_CURRENT);
        }
        ReportStack.flush(this, result != 0 && result != 10);
        return result;
    }

    @Override
    public int dispose_w_timestamp(IoTData instance_data, long instance_handle, Time_t source_timestamp) {
        int result = 0;
        long uWriter = 0L;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L) {
            result = Utilities.checkTime(source_timestamp);
            if (result == 0) {
                result = FooDataWriterImpl.jniDispose(uWriter, this.copyCache, instance_data, instance_handle, source_timestamp);
            }
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0 && result != 10);
        return result;
    }

    @Override
    public int writedispose(IoTData instance_data, long handle) {
        int result = 0;
        long uWriter = 0L;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L) {
            if (instance_data == null) {
                result = 3;
                ReportStack.report(result, "instance_data 'null' is invalid.");
            } else {
                result = FooDataWriterImpl.jniWritedispose(uWriter, this.copyCache, instance_data, handle, Utilities.DDS_TIMESTAMP_CURRENT);
            }
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0 && result != 10);
        return result;
    }

    @Override
    public int writedispose_w_timestamp(IoTData instance_data, long handle, Time_t source_timestamp) {
        int result = 9;
        long uWriter = 0L;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L) {
            if (instance_data == null) {
                result = 3;
                ReportStack.report(result, "instance_data 'null' is invalid.");
            } else {
                result = Utilities.checkTime(source_timestamp);
            }
            if (result == 0) {
                result = FooDataWriterImpl.jniWritedispose(uWriter, this.copyCache, instance_data, handle, source_timestamp);
            }
        }
        ReportStack.flush(this, result != 0 && result != 10);
        return result;
    }

    @Override
    public int get_key_value(IoTDataHolder key_holder, long handle) {
        int result = 0;
        long uWriter = 0L;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L) {
            if (key_holder == null) {
                result = 3;
                ReportStack.report(result, "key_holder 'null' is invalid.");
            } else {
                result = FooDataWriterImpl.jniGetKeyValue(uWriter, this.copyCache, key_holder, handle);
            }
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public long lookup_instance(IoTData instance_data) {
        long uWriter = 0L;
        long handle = 0L;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L) {
            if (instance_data == null) {
                int result = 3;
                ReportStack.report(result, "instance_data 'null' is invalid.");
            } else {
                handle = FooDataWriterImpl.jniLookupInstance(uWriter, this.copyCache, instance_data);
            }
        }
        ReportStack.flush(this, handle == 0L);
        return handle;
    }
}

