/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.common.BinarySensor;

public class ComplementarySensors
implements BinarySensor,
HasLifecycle {
    @LookupPath
    private String path;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<DigitalSensor> sensors = new ArrayList<DigitalSensor>();
    private DigitalSensor sensor;
    private DigitalSensor sensorC;

    public ComplementarySensors() {
    }

    ComplementarySensors(DigitalSensor s1, DigitalSensor s2) {
        this.sensors.add(s1);
        this.sensors.add(s2);
        this.loadSensors(this.sensors);
    }

    public void build() {
        this.loadSensors(this.sensors);
    }

    final void loadSensors(List<DigitalSensor> sensors) {
        if (sensors.size() != 2) {
            throw new RuntimeException("A ComplementarySensors instance requires two DigitalSensors as its children. For " + this.path + " there are " + sensors.size());
        }
        this.sensor = sensors.get(0);
        this.sensorC = sensors.get(1);
    }

    public DigitalSensor getSensor() {
        return this.sensor;
    }

    public DigitalSensor getSensorC() {
        return this.sensorC;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if this couple of sensors are in error.")
    public boolean isInError() {
        return this.sensor.isOn() == this.sensorC.isOn();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if sensor's value is 1 and sensorC's value is 0.")
    public boolean isOn() {
        return this.sensor.isOn() && !this.sensorC.isOn();
    }
}

