/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gantry;

import java.io.IOException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public enum DriverErrorType {
    COMMAND_ERROR,
    COMMUNICATION_ERROR,
    USAGE_ERROR,
    OTHER_ERROR;


    public static DriverErrorType classifyError(Exception topExc) {
        Throwable exc;
        for (exc = topExc; exc != null && !(exc instanceof DriverException); exc = exc.getCause()) {
        }
        if (exc == null) {
            exc = topExc;
        }
        DriverErrorType type = OTHER_ERROR;
        String msg = exc.getMessage();
        if (exc instanceof DriverTimeoutException) {
            type = COMMUNICATION_ERROR;
        } else if (msg == null) {
            Throwable cause = exc.getCause();
            if (cause != null && cause instanceof IOException) {
                type = COMMUNICATION_ERROR;
            }
        } else if (msg.startsWith("Invalid command")) {
            type = COMMAND_ERROR;
        } else if (msg.startsWith("Command fault")) {
            type = COMMAND_ERROR;
        } else if (msg.startsWith("Command timeout")) {
            type = COMMAND_ERROR;
        } else if (msg.startsWith("Connection closed")) {
            type = COMMUNICATION_ERROR;
        } else if (msg.startsWith("Invalid response")) {
            type = COMMUNICATION_ERROR;
        } else if (msg.startsWith("Device not connected")) {
            type = COMMUNICATION_ERROR;
        } else if (msg.startsWith("Invalid floating")) {
            type = USAGE_ERROR;
        } else if (msg.startsWith("Empty")) {
            type = COMMUNICATION_ERROR;
        }
        return type;
    }
}

