/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.CMDataReaderBuiltinTopicDataTypeSupport;
import DDS.CMDataWriterBuiltinTopicDataTypeSupport;
import DDS.CMParticipantBuiltinTopicDataTypeSupport;
import DDS.CMPublisherBuiltinTopicDataTypeSupport;
import DDS.CMSubscriberBuiltinTopicDataTypeSupport;
import DDS.Domain;
import DDS.DomainParticipant;
import DDS.DomainParticipantFactoryInterface;
import DDS.DomainParticipantFactoryQos;
import DDS.DomainParticipantFactoryQosHolder;
import DDS.DomainParticipantListener;
import DDS.DomainParticipantQos;
import DDS.DomainParticipantQosHolder;
import DDS.MainClassName;
import DDS.PARTICIPANTFACTORY_QOS_DEFAULT;
import DDS.PARTICIPANT_QOS_DEFAULT;
import DDS.ParticipantBuiltinTopicDataTypeSupport;
import DDS.PublicationBuiltinTopicDataTypeSupport;
import DDS.SubscriptionBuiltinTopicDataTypeSupport;
import DDS.TopicBuiltinTopicDataTypeSupport;
import DDS.TypeBuiltinTopicDataTypeSupport;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opensplice.dds.dcps.DomainImpl;
import org.opensplice.dds.dcps.DomainParticipantFactoryBase;
import org.opensplice.dds.dcps.DomainParticipantImpl;
import org.opensplice.dds.dcps.OSPLShutdown;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.TypeSupportImpl;
import org.opensplice.dds.dcps.Utilities;

public class DomainParticipantFactoryImpl
extends DomainParticipantFactoryBase
implements DomainParticipantFactoryInterface {
    private static final long serialVersionUID = 574757968947606395L;
    private static final DomainParticipantFactoryImpl TheFactory = new DomainParticipantFactoryImpl();
    private DomainParticipantFactoryQos factoryQos = Utilities.defaultDomainParticipantFactoryQos;
    private DomainParticipantQos defaultParticipantQos = Utilities.defaultDomainParticipantQos;
    private Set<DomainParticipantImpl> domainParticipants = new HashSet<DomainParticipantImpl>();
    private Set<Domain> domains = new HashSet<Domain>();

    @Override
    protected int deinit() {
        return super.deinit();
    }

    private DomainParticipantFactoryImpl() {
        try {
            System.loadLibrary("dcpssaj");
            int result = this.jniUserInitialize();
            if (result == 0) {
                String DisableShutdownHook = System.getProperty("osplNoDcpsShutdownHook", "false");
                if (DisableShutdownHook.equals("")) {
                    DisableShutdownHook = "true";
                }
                if (!Boolean.parseBoolean(DisableShutdownHook)) {
                    OSPLShutdown sh = new OSPLShutdown();
                    Runtime.getRuntime().addShutdownHook(sh);
                }
            }
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.println("Library \"dcpssaj\" could not be loaded: " + ule.getMessage());
        }
    }

    public static DomainParticipantFactoryImpl get_instance() {
        return TheFactory;
    }

    @Override
    public synchronized DomainParticipant create_participant(int domainId, DomainParticipantQos qos, DomainParticipantListener a_listener, int mask) {
        int result;
        ReportStack.start();
        DomainParticipantImpl dp = null;
        TypeSupportImpl participantTypeSupport = null;
        TypeSupportImpl topicTypeSupport = null;
        PublicationBuiltinTopicDataTypeSupport publicationTypeSupport = null;
        SubscriptionBuiltinTopicDataTypeSupport subscriptionTypeSupport = null;
        CMParticipantBuiltinTopicDataTypeSupport cmParticipantTypeSupport = null;
        CMPublisherBuiltinTopicDataTypeSupport cmPublisherTypeSupport = null;
        CMSubscriberBuiltinTopicDataTypeSupport cmSubscriberTypeSupport = null;
        CMDataWriterBuiltinTopicDataTypeSupport cmDataWriterTypeSupport = null;
        CMDataReaderBuiltinTopicDataTypeSupport cmDataReaderTypeSupport = null;
        TypeBuiltinTopicDataTypeSupport typeTypeSupport = null;
        MainClassName name = new MainClassName();
        if (domainId != -1) {
            if (qos == PARTICIPANT_QOS_DEFAULT.value) {
                qos = this.defaultParticipantQos;
            }
            if ((result = (dp = new DomainParticipantImpl()).init(name.getMainClassName(), domainId, qos)) == 0) {
                this.domainParticipants.add(dp);
                participantTypeSupport = new ParticipantBuiltinTopicDataTypeSupport();
                result = participantTypeSupport.register_type(dp, "DDS::ParticipantBuiltinTopicData");
            } else {
                dp = null;
            }
            if (result == 0) {
                dp.setParticipantDataCopyCache(participantTypeSupport.get_copyCache());
                topicTypeSupport = new TopicBuiltinTopicDataTypeSupport();
                result = topicTypeSupport.register_type(dp, "DDS::TopicBuiltinTopicData");
            }
            if (result == 0) {
                dp.setTopicBuiltinTopicDataCopyCache(topicTypeSupport.get_copyCache());
                publicationTypeSupport = new PublicationBuiltinTopicDataTypeSupport();
                result = publicationTypeSupport.register_type(dp, "DDS::PublicationBuiltinTopicData");
            }
            if (result == 0) {
                subscriptionTypeSupport = new SubscriptionBuiltinTopicDataTypeSupport();
                result = subscriptionTypeSupport.register_type(dp, "DDS::SubscriptionBuiltinTopicData");
            }
            if (result == 0) {
                cmParticipantTypeSupport = new CMParticipantBuiltinTopicDataTypeSupport();
                result = cmParticipantTypeSupport.register_type(dp, "DDS::CMParticipantBuiltinTopicData");
            }
            if (result == 0) {
                cmPublisherTypeSupport = new CMPublisherBuiltinTopicDataTypeSupport();
                result = cmPublisherTypeSupport.register_type(dp, "DDS::CMPublisherBuiltinTopicData");
            }
            if (result == 0) {
                cmSubscriberTypeSupport = new CMSubscriberBuiltinTopicDataTypeSupport();
                result = cmSubscriberTypeSupport.register_type(dp, "DDS::CMSubscriberBuiltinTopicData");
            }
            if (result == 0) {
                cmDataWriterTypeSupport = new CMDataWriterBuiltinTopicDataTypeSupport();
                result = cmDataWriterTypeSupport.register_type(dp, "DDS::CMDataWriterBuiltinTopicData");
            }
            if (result == 0) {
                cmDataReaderTypeSupport = new CMDataReaderBuiltinTopicDataTypeSupport();
                result = cmDataReaderTypeSupport.register_type(dp, "DDS::CMDataReaderBuiltinTopicData");
            }
            if (result == 0) {
                typeTypeSupport = new TypeBuiltinTopicDataTypeSupport();
                result = typeTypeSupport.register_type(dp, "DDS::TypeBuiltinTopicData");
            }
            if (result == 0) {
                result = dp.set_listener(a_listener, mask);
                if (this.factoryQos.entity_factory.autoenable_created_entities) {
                    result = dp.enable();
                }
            }
        } else {
            result = 3;
            ReportStack.report(result, "DomainParticipant is using an invalid domain identifier (" + domainId + ").");
        }
        if (result != 0 && dp != null) {
            this.delete_participant(dp);
            dp = null;
        }
        ReportStack.flush(result != 0);
        return dp;
    }

    @Override
    public synchronized int delete_participant(DomainParticipant a_participant) {
        int result = 0;
        ReportStack.start();
        if (a_participant == null) {
            result = 3;
            ReportStack.report(result, "a_participant 'null' is invalid.");
        } else {
            DomainParticipantImpl dp = (DomainParticipantImpl)a_participant;
            if (this.domainParticipants.remove(dp)) {
                result = dp.deinit();
                if (result == 4) {
                    this.domainParticipants.add(dp);
                }
            } else {
                result = 3;
                ReportStack.report(result, "DomainParticipant not created by DomainParticipantFactory.");
            }
        }
        ReportStack.flush(result != 0);
        return result;
    }

    @Override
    public synchronized DomainParticipant lookup_participant(int domainId) {
        ReportStack.start();
        DomainParticipant found = null;
        Iterator<DomainParticipantImpl> i = this.domainParticipants.iterator();
        if (domainId == Integer.MAX_VALUE) {
            domainId = this.jniGetDomainIdFromEnvUri();
        }
        while (found == null && i.hasNext()) {
            found = i.next();
            if (found.get_domain_id() == domainId) continue;
            found = null;
        }
        ReportStack.flush(false);
        return found;
    }

    @Override
    public int set_default_participant_qos(DomainParticipantQos qos) {
        int result = 0;
        ReportStack.start();
        result = Utilities.checkQos(qos);
        if (result == 0) {
            if (qos == PARTICIPANT_QOS_DEFAULT.value) {
                qos = Utilities.defaultDomainParticipantQos;
            }
            this.defaultParticipantQos = Utilities.deepCopy(qos);
        }
        ReportStack.flush(result != 0);
        return result;
    }

    @Override
    public int get_default_participant_qos(DomainParticipantQosHolder qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            qos.value = Utilities.deepCopy(this.defaultParticipantQos);
        }
        ReportStack.flush(result != 0);
        return result;
    }

    @Override
    public int set_qos(DomainParticipantFactoryQos qos) {
        int result = 0;
        ReportStack.start();
        result = Utilities.checkQos(qos);
        if (result == 0) {
            if (qos == PARTICIPANTFACTORY_QOS_DEFAULT.value) {
                qos = Utilities.defaultDomainParticipantFactoryQos;
            }
            this.factoryQos = Utilities.deepCopy(qos);
        }
        ReportStack.flush(result != 0);
        return result;
    }

    @Override
    public int get_qos(DomainParticipantFactoryQosHolder qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            qos.value = Utilities.deepCopy(this.factoryQos);
        }
        ReportStack.flush(result != 0);
        return 0;
    }

    @Override
    public synchronized Domain lookup_domain(int domain_id) {
        int result = 0;
        ReportStack.start();
        DomainImpl found = null;
        Iterator<Domain> i = this.domains.iterator();
        while (found == null && i.hasNext()) {
            found = (DomainImpl)i.next();
            if (found.get_domain_id() == domain_id) continue;
            found = null;
        }
        if (found == null) {
            found = new DomainImpl();
            result = found.init(domain_id);
            if (result == 0) {
                this.domains.add(found);
            } else {
                found = null;
            }
        }
        ReportStack.flush(found == null);
        return found;
    }

    @Override
    public synchronized int delete_domain(Domain a_domain) {
        int result = 0;
        ReportStack.start();
        if (a_domain == null) {
            result = 3;
            ReportStack.report(result, "a_domain 'null' is invalid.");
        } else if (this.domains.remove(a_domain)) {
            result = ((DomainImpl)a_domain).deinit();
            if (result == 4) {
                this.domains.add(a_domain);
            }
        } else {
            result = 3;
            ReportStack.report(result, "Domain not registered to DomainParticipantFactory.");
        }
        ReportStack.flush(result != 0);
        return result;
    }

    @Override
    public synchronized int delete_contained_entities() {
        ReportStack.start();
        int endResult = 0;
        Iterator<DomainParticipantImpl> ip = this.domainParticipants.iterator();
        while (ip.hasNext()) {
            DomainParticipantImpl dp = ip.next();
            int result = dp.delete_contained_entities();
            if (result == 0) {
                result = dp.deinit();
                if (result == 0 || result == 9) {
                    ip.remove();
                }
                if (result != 0) {
                    ReportStack.report(result, "Deletion of DomainParticipant contained in DomainParticipantFactory failed.");
                }
            } else {
                if (result == 9) {
                    ip.remove();
                }
                ReportStack.report(result, "delete_contained_entities failed on DomainParticipant contained in DomainParticipantFactory.");
            }
            if (endResult != 0) continue;
            endResult = result;
        }
        ReportStack.flush(endResult != 0);
        return endResult;
    }

    @Override
    public int detach_all_domains(boolean block_operations, boolean delete_entities) {
        return DomainParticipantFactoryImpl.jniUserDetach(block_operations, delete_entities);
    }

    private native int jniUserInitialize();

    private native String jniGetProcessName();

    private native int jniGetDomainIdFromEnvUri();

    protected static native int jniUserDetach(boolean var0, boolean var1);
}

